/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.tuia.pangea.center.api.dto.dayu.SceneConfig;
import cn.com.duiba.tuia.pangea.center.api.enums.ArgumentType;
import cn.com.duiba.tuia.pangea.center.api.remoteservice.RemoteDayuABService;
import cn.com.duiba.tuia.pangea.center.api.rsp.DayuResult;
import cn.com.duiba.tuia.pangea.center.api.utils.SceneUtils;
import java.util.EnumMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayuClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Long, SceneConfig> sceneConfigCacheMap = new ConcurrentHashMap<Long, SceneConfig>();
    private Map<Long, AtomicLong> sceneCounterMap = new ConcurrentHashMap<Long, AtomicLong>();
    private Long count = 50000L;
    private Long expireTime = 1800000L;
    private Timer timer = new Timer(true);
    @Resource
    private RemoteDayuABService remoteDayuABService;

    public void setCount(Long count) {
        this.count = count;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public DayuResult handleRequest(String sceneCode, Object param, ArgumentType type) {
        EnumMap<ArgumentType, Object> params = new EnumMap<ArgumentType, Object>(ArgumentType.class);
        params.put(type, param);
        return this.handleRequest(sceneCode, params);
    }

    public DayuResult handleRequest(String sceneCode, Map<ArgumentType, Object> params) {
        this.checkParam(params);
        Long sceneId = Long.parseLong(sceneCode.split(":")[1]);
        this.preHandleRequest(sceneId);
        SceneConfig sceneConfig = this.sceneConfigCacheMap.get(sceneId);
        if (sceneConfig != null) {
            return SceneUtils.resolve(sceneConfig, params);
        }
        this.getSceneConfigAndPutItIntoCache(sceneId);
        return SceneUtils.resolve(this.sceneConfigCacheMap.get(sceneId), params);
    }

    private void getSceneConfigAndPutItIntoCache(Long sceneId) {
    }

    private void startUpdateSceneConfigSchedule(final Long sceneId) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    DayuClient.this.getSceneConfigAndPutItIntoCache(sceneId);
                }
                catch (Exception e) {
                    DayuClient.this.logger.error("\u7039\u6c2d\u6902\u93c7\u5b58\u67ca\u95b0\u5d87\u7586\u6fb6\u8fab\u89e6");
                }
            }
        }, this.expireTime, (long)this.expireTime);
    }

    private void preHandleRequest(Long sceneId) {
        AtomicLong parseCount = this.sceneCounterMap.putIfAbsent(sceneId, new AtomicLong(1L));
        if (parseCount == null) {
            this.startUpdateSceneConfigSchedule(sceneId);
        } else if (parseCount.incrementAndGet() % this.count == 0L) {
            this.getSceneConfigAndPutItIntoCache(sceneId);
        }
    }

    private void checkParam(Map<ArgumentType, Object> params) {
        if (params == null || params.isEmpty()) {
            this.logger.error("error! the params is empty");
            throw new NullPointerException("error! the params is empty");
        }
    }
}

