package cn.com.duiba.tuia.pangea.center.api.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2019-09-05 13:55
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class ReqAppStatistics extends BaseQueryReq {

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 最大导出一万条. */
    public static final int MAX_EXPORT_SIZE = 10000;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;

    private String appName;

    private Long slotId;

    private String slotName;

    private List<Long> slotIds;

    private Long planId;

    private Integer exportType;

    private String creator;
}
