/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.collections.CollectionUtils;

public class X509CertificateUtils {
    private X509CertificateUtils() {
    }

    public static List<String> getHostnames(byte[] bs) {
        try {
            Collection<List<?>> sanList;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(bs));
            String dn = x509certificate.getSubjectX500Principal().getName();
            LdapName ldapDN = new LdapName(dn);
            String hostnameFromCN = null;
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                hostnameFromCN = (String)rdn.getValue();
                break;
            }
            HashSet<String> hostnames = new HashSet<String>();
            if (hostnameFromCN != null) {
                hostnames.add(hostnameFromCN);
            }
            if (!CollectionUtils.isEmpty(sanList = x509certificate.getSubjectAlternativeNames())) {
                Iterator<List<?>> iterator = sanList.iterator();
                while (iterator.hasNext()) {
                    List<?> obj;
                    List<?> innerList = obj = iterator.next();
                    int type = (Integer)innerList.get(0);
                    String hostname = (String)innerList.get(1);
                    if (type != 2 && type != 7) continue;
                    hostnames.add(hostname);
                }
            }
            return new ArrayList<String>(hostnames);
        }
        catch (CertificateException | InvalidNameException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Date getEndDate(byte[] bs) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(bs));
            return x509certificate.getNotAfter();
        }
        catch (CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

