/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.annotation.Annotation;
import springfox.documentation.RequestHandler;

public class RequestHandlerSelectors {
    private RequestHandlerSelectors() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<RequestHandler> any() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<RequestHandler> none() {
        return Predicates.alwaysFalse();
    }

    public static Predicate<RequestHandler> withMethodAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.isAnnotatedWith(annotation);
            }
        };
    }

    public static Predicate<RequestHandler> withClassAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return (Boolean)RequestHandlerSelectors.declaringClass(input).transform(RequestHandlerSelectors.annotationPresent(annotation)).or((Object)false);
            }
        };
    }

    private static Function<Class<?>, Boolean> annotationPresent(final Class<? extends Annotation> annotation) {
        return new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> input) {
                return input.isAnnotationPresent(annotation);
            }
        };
    }

    private static Function<Class<?>, Boolean> handlerPackage(final String basePackage) {
        return new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> input) {
                return input.getPackage().getName().startsWith(basePackage);
            }
        };
    }

    public static Predicate<RequestHandler> basePackage(final String basePackage) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return (Boolean)RequestHandlerSelectors.declaringClass(input).transform(RequestHandlerSelectors.handlerPackage(basePackage)).or((Object)true);
            }
        };
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable(input.declaringClass());
    }
}

