package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqFlowBaseByPageDto;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqShieldFlowDto;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqUpdateRatioDto;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqUpdateStatusDto;
import cn.com.duiba.tuia.pangea.center.api.req.flowmanager.ReqWholeOrSlotRatioDto;
import cn.com.duiba.tuia.pangea.center.api.req.openweb.PgPlanSlotRatioReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.flowmanager.RspFlowBaseDto;
import cn.com.duiba.tuia.pangea.center.api.rsp.flowmanager.RspShieldFlowDto;
import cn.com.duiba.tuia.pangea.center.api.rsp.flowmanager.RspWholeOrSlotRatioDto;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-08 10:25
 */
@AdvancedFeignClient
public interface RemoteAppSlotFlowService {


    /**
     * 查询 可测试流量
     * @param dto
     * @return
     */
    PageResultDto<RspFlowBaseDto> selectTestSlotListPage(ReqFlowBaseByPageDto dto);

    /**
     * 查询 黑名单测试流量
     * @param dto
     * @return
     */
    PageResultDto<RspShieldFlowDto> selectShieldSlotListPage(ReqShieldFlowDto dto);


    /**
     * 查询 大盘占比 切流量
     * @param dto
     * @return
     */
    RspWholeOrSlotRatioDto selectTestWholeSlotRatio(ReqWholeOrSlotRatioDto dto);

    /**
     * 查询媒体广告位 切流量占比
     * @param dto
     * @return
     */
    RspWholeOrSlotRatioDto selectTestSomeSlotRatio(ReqWholeOrSlotRatioDto dto);

    /**
     * 更新流量占比
     * @param dto
     * @return
     */
    Integer updateRatio(ReqUpdateRatioDto dto);

    /**
     * 更新black_deleted状态
     * @param reqUpdateStatusDto
     * @return
     */
    Integer addOrUpdateStatus(ReqUpdateStatusDto reqUpdateStatusDto);

    /**
     * 单个更新移除 TestAppSlot 名单
     * @param reqUpdateStatusDto
     * @return
     */
    Integer removeTestAppSlotShield(ReqUpdateStatusDto reqUpdateStatusDto);


    /**
     * 获取某个测试计划的比例
     * @param ratioReq
     * @return
     */
    Integer getRatioBySlotIdAndActivityId(PgPlanSlotRatioReq ratioReq);

    /**
     * 批量上传 cvs 黑名单
     * @param reqUpdateStatusDto
     * @return
     */
    Integer uploadBatchShieldList(ReqUpdateStatusDto reqUpdateStatusDto);

}
