package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.req.PrecentDetailReq;
import cn.com.duiba.tuia.pangea.center.api.req.ReqActivity;
import cn.com.duiba.tuia.pangea.center.api.req.ReqAddPrecent;
import cn.com.duiba.tuia.pangea.center.api.req.ReqStopActivity;
import cn.com.duiba.tuia.pangea.center.api.req.ReqStopSlot;
import cn.com.duiba.tuia.pangea.center.api.rsp.RspPrecent;
import cn.com.duiba.tuia.pangea.center.api.rsp.RspPrecentDetail;

import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2019-09-02 15:01
 */
@AdvancedFeignClient
public interface RemoteActivityService {
    /**
     * 根据plan获取对应下组id
     * @param reqActivity
     * @return
     */
    List<Long> getActivityIdsByPlanId(ReqActivity reqActivity);

    /**
     * 根据planId获取下面所有广告位id
     * @param planId
     * @return
     */
    List<Long> getAllSlotIdByPlanId(Long planId);

    /**
     * 停止测试计划
     * @param reqStopActivity
     */
    void stopActivity(ReqStopActivity reqStopActivity);


    /**
     * 停止测试计划
     * @param reqStopActivity
     */
    void stopActivityAll(ReqStopActivity reqStopActivity);

    /**
     *获取所有的测试中的测试活动
     * @return
     */
    List<Long> getAllTestActivity();

    /**
     * 追加投放
     * @param req
     */
    void addPrecent(ReqAddPrecent req);

    /**
     * 获取投放详情
     * @param req
     * @return
     */
    RspPrecentDetail getPrecentDetail(PrecentDetailReq req);

    /**
     * 停止测试
     * @param req
     */
    void stopSlot(ReqStopSlot req);
}
