package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.ActivityDto;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.dto.PlanDto;
import cn.com.duiba.tuia.pangea.center.api.dto.openweb.PgPlanActivityDto;
import cn.com.duiba.tuia.pangea.center.api.req.PlanInsertReq;
import cn.com.duiba.tuia.pangea.center.api.req.PlanQueryReq;
import cn.com.duiba.tuia.pangea.center.api.req.PlanUpdateReq;
import cn.com.duiba.tuia.pangea.center.api.req.SlotUvQueryReq;
import cn.com.duiba.tuia.pangea.center.api.req.openweb.PgPlanSlotRatioReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.plan.SlotIdToContrastRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 测试计划
 */
@AdvancedFeignClient
public interface RemotePlanService {


    PageResultDto<PlanDto> pages(PlanQueryReq req);

    DubboResult<Map<String, Object>> next(PlanInsertReq req);

    DubboResult<Long> addPlan(PlanInsertReq req);

    PlanDto selectById(Long id);

    DubboResult<Integer> updatePlan(PlanUpdateReq req);

    List<ActivityDto> findByActivityIds(List<Long> activityIds);

    DubboResult<Boolean> modifyPlanStatus(Long id, Integer planStatus);

    Map<String, Object> getSlotDataByActivityIds(List<Long> activityIds);

    List<PgPlanActivityDto> getPlanInfoByPgReq(PgPlanSlotRatioReq ratioReq);

    List<SlotIdToContrastRsp> getSlotIdToContrast(SlotUvQueryReq req);

}
