/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCheck {
    private static final String VERSION = VersionCheck.getVersion(VersionCheck.class, "1.1.5");
    private static final Logger logger = LoggerFactory.getLogger(VersionCheck.class);

    private VersionCheck() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void checkDuplicate(Class<?> cls) {
        VersionCheck.checkDuplicate(cls.getName().replace('.', '/') + ".class");
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            String version = cls.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if (version == null || version.length() == 0) {
                CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    logger.info("No codeSource for class {} when getVersion, use default version {}", (Object)cls.getName(), (Object)defaultVersion);
                } else {
                    String file = codeSource.getLocation().getFile();
                    if (file != null && file.length() > 0 && file.endsWith(".jar")) {
                        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
                        if (i >= 0) {
                            file = file.substring(i + 1);
                        }
                        if ((i = file.indexOf(45)) >= 0) {
                            file = file.substring(i + 1);
                        }
                        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf(45)) >= 0) {
                            file = file.substring(i + 1);
                        }
                        version = file;
                    }
                }
            }
            return version == null || version.length() == 0 ? defaultVersion : version;
        }
        catch (Exception e) {
            logger.error("return default version, ignore exception " + e.getMessage(), (Throwable)e);
            return defaultVersion;
        }
    }

    public static void checkDuplicate(String path) {
        try {
            Enumeration<URL> urls = VersionCheck.class.getClassLoader().getResources(path);
            HashSet<String> files = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String file;
                URL url = urls.nextElement();
                if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
                files.add(file);
            }
            if (files.size() > 1) {
                logger.error("Duplicate class {} in {} jar {}", new Object[]{path, files.size(), files});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        VersionCheck.checkDuplicate(VersionCheck.class);
    }
}

