/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlUtils {
    private static Joiner joiner = Joiner.on((String)"&").skipNulls();

    public static Map<String, String> explainURLParams(String params) {
        String[] arrSplit;
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        for (String strSplit : arrSplit = params.split("[&]")) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0] == "") continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public static String buildURLParams(Map<String, String> params) {
        if (Objects.equal(null, params) || params.isEmpty()) {
            return "";
        }
        List paramList = Lists.transform((List)Lists.newArrayList(params.entrySet()), entry -> {
            StringBuffer sb = new StringBuffer();
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            return sb.toString();
        });
        return joiner.join((Iterable)paramList);
    }

    private static String truncateUrlPage(String strURL) {
        String url = strURL.trim().toLowerCase();
        String[] arrSplit = url.split("[?]");
        if (arrSplit.length > 1) {
            return arrSplit[1];
        }
        return null;
    }

    public static Map<String, String> uRLRequest(String url) {
        String strUrlParam = UrlUtils.truncateUrlPage(url);
        if (strUrlParam == null) {
            return Collections.emptyMap();
        }
        return UrlUtils.explainURLParams(strUrlParam);
    }

    public static String urlPage(String strURL) {
        String strPage = null;
        String url = strURL.trim().toLowerCase();
        String[] arrSplit = url.split("[?]");
        if (url.length() > 0) {
            if (arrSplit.length > 1) {
                if (arrSplit[0] != null) {
                    strPage = arrSplit[0];
                }
            } else {
                strPage = url;
            }
        }
        return strPage;
    }

    public static String appendParams(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(url);
        if (sb.indexOf("?") > 0) {
            sb.append("&");
            sb.append(UrlUtils.buildURLParams(params));
        } else {
            sb.append("?");
            sb.append(UrlUtils.buildURLParams(params));
        }
        return sb.toString();
    }
}

