package cn.com.duiba.tuia.pangea.center.api.req.resource;

import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;

/**
 * 浮标/下拉、返回拦截、响应式插件、弹层 数据查询
 * @author miaohongshuai
*/
@Data
public class ResourceReportReq extends BaseQueryReq {

    @ApiModelProperty(value = "测试计划id", required = true)
    private Long planId;
    @ApiModelProperty(value = "测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层", required = true)
    private Integer testType;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startTime;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endTime;

    @ApiModelProperty(value = "创建者", required = true)
    private String creator;
}
