package cn.com.duiba.tuia.pangea.center.api.rsp.resource;

import cn.com.duiba.tuia.pangea.center.api.dto.resource.TestResourceFlowDTO;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * 广告位活动的资源测试组列表查询 响应
 * @author miaohongshuai
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
@Builder
public class ResourceFlowTestListRsp implements Serializable {

    private static final long serialVersionUID = 4375477196556355774L;
    /**
     * 媒体ID
     */
    private Long appId;
    /**
     * 广告位ID
     */
    private Long slotId;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 测试计划ID
     */
    private Long planId;
    /**
     * 测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层
     */
    private Integer testType;
    /**
     * 测试总占比
     */
    private Integer testVisitorRatio;
    /**
     * 测试总量级
     */
    private Long testTotalAccessUv;
    /**
     * 测试组信息
     */
    List<TestResourceFlowDTO> testGroupList;
}
