/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf;

import cn.com.duiba.wolf.perf.PerfCollector;
import cn.com.duiba.wolf.perf.PerfResult;
import cn.com.duiba.wolf.perf.PerfRunable;
import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Performances {
    private int count;
    private int loop;
    private PerfRunable perfRunable;
    private final PerfCollector perfCollector = new PerfCollector();

    public static Performances newBuilder() {
        return new Performances();
    }

    public Performances count(int count) {
        this.count = count;
        return this;
    }

    public Performances perfRunable(PerfRunable perfRunable) {
        this.perfRunable = perfRunable;
        return this;
    }

    public Performances loop(int loop) {
        this.loop = loop;
        return this;
    }

    public PerfResult start() {
        Preconditions.checkArgument((this.loop > 0 ? 1 : 0) != 0, (Object)"loop must bigger than 0");
        Preconditions.checkArgument((this.count > 0 ? 1 : 0) != 0, (Object)"count must bigger than 0");
        ExecutorService executorService = Executors.newFixedThreadPool(this.count);
        CountDownLatch countDown = new CountDownLatch(this.loop);
        this.perfCollector.setStartTime(System.currentTimeMillis());
        for (int i = 0; i < this.loop; ++i) {
            executorService.submit(() -> {
                for (int j = 0; j < this.count; ++j) {
                    try {
                        long startTime = System.currentTimeMillis();
                        this.perfRunable.run();
                        long endTime = System.currentTimeMillis();
                        this.perfCollector.addValue(endTime - startTime);
                        this.perfCollector.addSuccess();
                        continue;
                    }
                    catch (Exception e) {
                        this.perfCollector.addFail();
                    }
                }
                countDown.countDown();
            });
        }
        try {
            countDown.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.perfCollector.setEndTime(System.currentTimeMillis());
        return this.perfCollector.compute();
    }
}

