/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NumberUtils {
    public static int parseInt(String str, int defaultValue) {
        int value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static float parseFloat(String str, float defaultValue) {
        float value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Float.parseFloat(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static long parseLong(String str, long defaultValue) {
        long value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Long.parseLong(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static double parseDouble(String str, double defaultValue) {
        double value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Double.parseDouble(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Long add(Long val1, Long val2) {
        Long tmpval1 = val1 != null ? val1 : 0L;
        Long tmpval2 = val2 != null ? val2 : 0L;
        return tmpval1 + tmpval2;
    }

    public static Integer add(Integer val1, Integer val2) {
        Integer tmpval1 = val1 != null ? val1 : 0;
        Integer tmpval2 = val2 != null ? val2 : 0;
        return tmpval1 + tmpval2;
    }

    public static Double add(Double val1, Double val2) {
        Double tmpval1 = val1 != null ? val1 : 0.0;
        Double tmpval2 = val2 != null ? val2 : 0.0;
        return tmpval1 + tmpval2;
    }

    public static String numberFormat(double f, int fractionDigits) {
        NumberFormat nf1 = NumberFormat.getInstance(Locale.CHINA);
        nf1.setMaximumFractionDigits(fractionDigits);
        nf1.setGroupingUsed(false);
        return nf1.format(f);
    }

    public static String numberFormat(float n, int fractionDigits) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(fractionDigits);
        return nf.format(n);
    }

    public static String percentFormat(double d) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getPercentInstance();
        nf.applyPattern("##.##%");
        return nf.format(d);
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

