/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ConstraintTree<A extends Annotation> {
    private static final String TYPE_USE = "TYPE_USE";
    private static final Log log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        Set<ConstraintDescriptorImpl<?>> composingConstraints = descriptor.getComposingConstraintImpls();
        this.children = CollectionHelper.newArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl<?> composingDescriptor : composingConstraints) {
            ConstraintTree<?> treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public final List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public final <T> boolean validateConstraints(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext) {
        HashSet<ConstraintViolation<T>> constraintViolations = CollectionHelper.newHashSet();
        this.validateConstraints(executionContext, valueContext, constraintViolations);
        if (!constraintViolations.isEmpty()) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    private <T, V> void validateConstraints(ValidationContext<T> validationContext, ValueContext<?, V> valueContext, Set<ConstraintViolation<T>> constraintViolations) {
        Set<ConstraintViolation<T>> localViolations;
        CompositionResult compositionResult = this.validateComposingConstraints(validationContext, valueContext, constraintViolations);
        if (this.mainConstraintNeedsEvaluation(validationContext, constraintViolations)) {
            if (log.isTraceEnabled()) {
                log.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), this.descriptor);
            }
            ConstraintValidator<A, V> validator = this.getInitializedConstraintValidator(validationContext, valueContext);
            ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(validationContext.getParameterNames(), validationContext.getTimeProvider(), valueContext.getPropertyPath(), this.descriptor);
            localViolations = this.validateSingleConstraint(validationContext, valueContext, constraintValidatorContext, validator);
            if (localViolations.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
            } else {
                compositionResult.setAllTrue(false);
            }
        } else {
            localViolations = Collections.emptySet();
        }
        if (!this.passesCompositionTypeRequirement(constraintViolations, compositionResult)) {
            this.prepareFinalConstraintViolations(validationContext, valueContext, constraintViolations, localViolations);
        }
    }

    private <T, V> ConstraintValidator<A, V> getInitializedConstraintValidator(ValidationContext<T> validationContext, ValueContext<?, V> valueContext) {
        Type validatedValueType = valueContext.getDeclaredTypeOfValidatedElement();
        ValidatedValueUnwrapper<?> validatedValueUnwrapper = validationContext.getValidatedValueUnwrapper(validatedValueType);
        if (valueContext.getUnwrapMode().equals((Object)UnwrapMode.AUTOMATIC)) {
            return this.getConstraintValidatorInstanceForAutomaticUnwrapping(validationContext, valueContext);
        }
        if (valueContext.getUnwrapMode().equals((Object)UnwrapMode.UNWRAP) || TYPE_USE.equals(valueContext.getElementType().name())) {
            return this.getInitializedValidatorInstanceForWrappedInstance(validationContext, valueContext, validatedValueType, validatedValueUnwrapper);
        }
        return this.getConstraintValidatorNoUnwrapping(validationContext, valueContext);
    }

    private <T, V> ConstraintValidator<A, V> getInitializedValidatorInstanceForWrappedInstance(ValidationContext<T> validationContext, ValueContext<?, V> valueContext, Type validatedValueType, ValidatedValueUnwrapper<V> validatedValueUnwrapper) {
        if (validatedValueUnwrapper == null) {
            throw log.getNoUnwrapperFoundForTypeException(valueContext.getDeclaredTypeOfValidatedElement());
        }
        valueContext.setValidatedValueHandler(validatedValueUnwrapper);
        validatedValueType = validatedValueUnwrapper.getValidatedValueType(validatedValueType);
        ConstraintValidator validator = validationContext.getConstraintValidatorManager().getInitializedValidator(validatedValueType, this.descriptor, validationContext.getConstraintValidatorFactory());
        if (validator == null) {
            this.throwExceptionForNullValidator(validatedValueType, valueContext.getPropertyPath().asString());
        }
        return validator;
    }

    private void throwExceptionForNullValidator(Type validatedValueType, String path) {
        if (this.descriptor.getConstraintType() == ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER) {
            throw log.getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException(this.descriptor.getAnnotationType());
        }
        String className = validatedValueType.toString();
        if (validatedValueType instanceof Class) {
            Class clazz = (Class)validatedValueType;
            className = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
        }
        throw log.getNoValidatorFoundForTypeException(this.descriptor.getAnnotationType(), className, path);
    }

    private <T, V> ConstraintValidator<A, V> getConstraintValidatorInstanceForAutomaticUnwrapping(ValidationContext<T> validationContext, ValueContext<?, V> valueContext) {
        Type validatedValueType = valueContext.getDeclaredTypeOfValidatedElement();
        ValidatedValueUnwrapper<?> validatedValueUnwrapper = validationContext.getValidatedValueUnwrapper(validatedValueType);
        if (validatedValueUnwrapper == null) {
            return this.getConstraintValidatorNoUnwrapping(validationContext, valueContext);
        }
        ConstraintValidator validatorForWrappedValue = validationContext.getConstraintValidatorManager().getInitializedValidator(validatedValueUnwrapper.getValidatedValueType(validatedValueType), this.descriptor, validationContext.getConstraintValidatorFactory());
        ConstraintValidator validatorForWrapper = validationContext.getConstraintValidatorManager().getInitializedValidator(valueContext.getDeclaredTypeOfValidatedElement(), this.descriptor, validationContext.getConstraintValidatorFactory());
        if (validatorForWrappedValue != null && validatorForWrapper != null) {
            throw log.getConstraintValidatorExistsForWrapperAndWrappedValueException(valueContext.getPropertyPath(), this.descriptor.getAnnotationType(), validatedValueUnwrapper.getClass());
        }
        if (validatorForWrappedValue == null && validatorForWrapper == null) {
            throw log.getNoValidatorFoundForTypeException(this.descriptor.getAnnotationType(), validatedValueType.toString(), valueContext.getPropertyPath().toString());
        }
        if (validatorForWrappedValue != null) {
            valueContext.setValidatedValueHandler(validatedValueUnwrapper);
            return validatorForWrappedValue;
        }
        valueContext.setValidatedValueHandler(null);
        return validatorForWrapper;
    }

    private <T, V> ConstraintValidator<A, V> getConstraintValidatorNoUnwrapping(ValidationContext<T> validationContext, ValueContext<?, V> valueContext) {
        valueContext.setValidatedValueHandler(null);
        Type validatedValueType = valueContext.getDeclaredTypeOfValidatedElement();
        ConstraintValidator validator = validationContext.getConstraintValidatorManager().getInitializedValidator(validatedValueType, this.descriptor, validationContext.getConstraintValidatorFactory());
        if (validator == null) {
            this.throwExceptionForNullValidator(validatedValueType, valueContext.getPropertyPath().asString());
        }
        return validator;
    }

    private <T> boolean mainConstraintNeedsEvaluation(ValidationContext<T> executionContext, Set<ConstraintViolation<T>> constraintViolations) {
        if (!this.descriptor.getComposingConstraints().isEmpty() && this.descriptor.getMatchingConstraintValidatorClasses().isEmpty()) {
            return false;
        }
        if (this.descriptor.isReportAsSingleViolation() && this.descriptor.getCompositionType() == CompositionType.AND && !constraintViolations.isEmpty()) {
            return false;
        }
        return !executionContext.isFailFastModeEnabled() || constraintViolations.isEmpty();
    }

    private <T> void prepareFinalConstraintViolations(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, Set<ConstraintViolation<T>> constraintViolations, Set<ConstraintViolation<T>> localViolations) {
        if (this.reportAsSingleViolation()) {
            constraintViolations.clear();
            if (localViolations.isEmpty()) {
                String message = (String)this.getDescriptor().getAttributes().get("message");
                ConstraintViolationCreationContext constraintViolationCreationContext = new ConstraintViolationCreationContext(message, valueContext.getPropertyPath());
                ConstraintViolation<T> violation = executionContext.createConstraintViolation(valueContext, constraintViolationCreationContext, this.descriptor);
                constraintViolations.add(violation);
            }
        }
        constraintViolations.addAll(localViolations);
    }

    private <T> CompositionResult validateComposingConstraints(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, Set<ConstraintViolation<T>> constraintViolations) {
        CompositionResult compositionResult = new CompositionResult(true, false);
        List<ConstraintTree<?>> children = this.getChildren();
        for (ConstraintTree<?> tree : children) {
            HashSet<ConstraintViolation<T>> tmpViolations = CollectionHelper.newHashSet();
            super.validateConstraints(executionContext, valueContext, tmpViolations);
            constraintViolations.addAll(tmpViolations);
            if (tmpViolations.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
                if (this.descriptor.getCompositionType() != CompositionType.OR) continue;
                break;
            }
            compositionResult.setAllTrue(false);
            if (this.descriptor.getCompositionType() != CompositionType.AND || !executionContext.isFailFastModeEnabled() && !this.descriptor.isReportAsSingleViolation()) continue;
            break;
        }
        return compositionResult;
    }

    private boolean passesCompositionTypeRequirement(Set<?> constraintViolations, CompositionResult compositionResult) {
        CompositionType compositionType = this.getDescriptor().getCompositionType();
        boolean passedValidation = false;
        switch (compositionType) {
            case OR: {
                passedValidation = compositionResult.isAtLeastOneTrue();
                break;
            }
            case AND: {
                passedValidation = compositionResult.isAllTrue();
                break;
            }
            case ALL_FALSE: {
                boolean bl = passedValidation = !compositionResult.isAtLeastOneTrue();
            }
        }
        assert (!passedValidation || compositionType != CompositionType.AND || constraintViolations.isEmpty());
        if (passedValidation) {
            constraintViolations.clear();
        }
        return passedValidation;
    }

    private <T, V> Set<ConstraintViolation<T>> validateSingleConstraint(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator) {
        boolean isValid;
        try {
            Object validatedValue = valueContext.getCurrentValidatedValue();
            isValid = validator.isValid(validatedValue, (ConstraintValidatorContext)constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw log.getExceptionDuringIsValidCallException(e);
        }
        if (!isValid) {
            return executionContext.createConstraintViolations(valueContext, constraintValidatorContext);
        }
        return Collections.emptySet();
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation() || this.getDescriptor().getCompositionType() == CompositionType.ALL_FALSE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append('}');
        return sb.toString();
    }

    private static final class CompositionResult {
        private boolean allTrue;
        private boolean atLeastOneTrue;

        CompositionResult(boolean allTrue, boolean atLeastOneTrue) {
            this.allTrue = allTrue;
            this.atLeastOneTrue = atLeastOneTrue;
        }

        public boolean isAllTrue() {
            return this.allTrue;
        }

        public boolean isAtLeastOneTrue() {
            return this.atLeastOneTrue;
        }

        public void setAllTrue(boolean allTrue) {
            this.allTrue = allTrue;
        }

        public void setAtLeastOneTrue(boolean atLeastOneTrue) {
            this.atLeastOneTrue = atLeastOneTrue;
        }
    }
}

