package cn.com.duiba.tuia.pangea.center.api.req.flowmanager;

import cn.com.duiba.tuia.pangea.center.api.constant.SymbolConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-06 12:58
 */
@Data
public class ReqOperateShieldDto implements Serializable {

    private static final long serialVersionUID = 91777783199865422L;

    private Long oneId;

    private Byte operateType;

    private String operateValue;

    private Set<Long> valueList;

    public void setValueList(final String operateValue, final Set<Long> valueList) {
        final Set<Long> list =
                Arrays.stream(StringUtils.split(operateValue, SymbolConstant.SPLIT_COMMA)).map(
                        Long::valueOf).collect(Collectors.toSet());
        if (Objects.isNull(valueList)) {
            this.valueList = list;
        } else {
            valueList.addAll(list);
        }
    }
}
