package cn.com.duiba.tuia.pangea.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.pangea.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.pangea.center.api.req.ReqResourceExportStatistics;
import cn.com.duiba.tuia.pangea.center.api.req.resource.ReqStopResource;
import cn.com.duiba.tuia.pangea.center.api.req.resource.ResourceReportReq;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.DayResourceMediaReportRspList;
import cn.com.duiba.tuia.pangea.center.api.rsp.resource.DayResourceReportRspList;

/**
 * 浮标/下拉、返回拦截、响应式插件、弹层的数据日统计服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemoteResourceDayReportService {

    /**
     * 分页浮标/下拉、返回拦截、响应式插件、弹层的日数据列表
     * @param req
     * @return
     */
    PageResultDto<DayResourceReportRspList> selectDayReportList(ResourceReportReq req);

    /**
     * 获取分页列表
     * @param req
     * @return
     */
    PageResultDto<DayResourceMediaReportRspList> selectAppData(ReqResourceExportStatistics req);

    /**
     * 根据测试计划id、组序号或根据测试计划id、广告位id、活动id、组序号 停止资源的 测试组
     * @param req
     * @return
     */
    Boolean stopResource(ReqStopResource req);

    /**
     * 根据测试计划id、广告位id、活动id、组序号 停止资源的 测试组
     * @param req
     * @return
     */
    @Deprecated
    Boolean stopSlotActivityResource(ReqStopResource req);
}
