/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.level.Level;
import java.io.Serializable;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", new Object[]{level}));
    }

    @Override
    public void trace(Throwable t) {
        this.trace(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void info(Throwable t) {
        this.info(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void error(Throwable t) {
        this.error(t, ExceptionUtil.getSimpleMessage(t), new Object[0]);
    }
}

