package cn.com.duiba.tuia.purchase.web.api.localservice;

import cn.com.duiba.tuia.purchase.web.api.dto.PutPlanDto;
import cn.com.duiba.tuia.purchase.web.api.remoteservice.RemotePurchaseService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import net.sf.cglib.asm.$ByteVector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class OcpcPurchaseService {

    @Resource
    private RemotePurchaseService remotePurchaseService;


    private LoadingCache<Long, Optional<PutPlanDto>> caffeine = Caffeine.newBuilder()
            .maximumSize(6000)
            .initialCapacity(20)
            .refreshAfterWrite(5, TimeUnit.SECONDS)
            .expireAfterWrite(20, TimeUnit.SECONDS)
            .build(this::queryByChannelId);


    public Optional<PutPlanDto> getByChannelId(Long channelId) {
        return caffeine.get(channelId);
    }

    /**
     * 根据渠道号查询对应的计划 不存在则返回空计划
     *
     * @param channelId
     * @return
     */
    private Optional<PutPlanDto> queryByChannelId(Long channelId) {
        PutPlanDto putPlanDto = remotePurchaseService.getPlanByChannelId(channelId);
        //加一层空对象缓存 防止恶意请求
        if (putPlanDto == null) {
            return Optional.empty();
        }
        return Optional.of(putPlanDto);
    }

    public String getEventType(Long channelId, String eventType) {
        Optional<PutPlanDto> optional = getByChannelId(channelId);
        if (!optional.isPresent()) {
            return null;
        }
        PutPlanDto dto = optional.get();
        if (!dto.getIsCallBack() || !dto.getActionIdMap().containsKey(eventType) || StringUtils.isBlank(dto.getActionIdMap().get(eventType))) {
            log.info("投放计划设定不回传 {},{}", channelId, eventType);
            return null;
        }
        //概率没命中 万分比
        if (RandomUtils.nextInt(10000) >= dto.getProbabilityBack()) {
            log.info("概率没命中 {},{}", channelId, eventType);
            return null;
        }
        return dto.getActionIdMap().get(eventType);
    }

}

