/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.purchase.web.api.localservice;

import cn.com.duiba.tuia.purchase.web.api.dto.PutPlanDto;
import cn.com.duiba.tuia.purchase.web.api.remoteservice.RemotePurchaseService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OcpcPurchaseService {
    private static final Logger log = LoggerFactory.getLogger(OcpcPurchaseService.class);
    @Resource
    private RemotePurchaseService remotePurchaseService;
    private LoadingCache<Long, Optional<PutPlanDto>> caffeine = Caffeine.newBuilder().maximumSize(6000L).initialCapacity(20).refreshAfterWrite(5L, TimeUnit.SECONDS).expireAfterWrite(20L, TimeUnit.SECONDS).build(this::queryByChannelId);

    public Optional<PutPlanDto> getByChannelId(Long channelId) {
        return (Optional)this.caffeine.get((Object)channelId);
    }

    private Optional<PutPlanDto> queryByChannelId(Long channelId) {
        PutPlanDto putPlanDto = this.remotePurchaseService.getPlanByChannelId(channelId);
        if (putPlanDto == null) {
            return Optional.empty();
        }
        return Optional.of(putPlanDto);
    }

    public String getEventType(Long channelId, String eventType) {
        Optional<PutPlanDto> optional = this.getByChannelId(channelId);
        if (!optional.isPresent()) {
            return null;
        }
        PutPlanDto dto = optional.get();
        if (!dto.getIsCallBack().booleanValue() || !dto.getActionIdMap().containsKey(eventType) || StringUtils.isBlank((String)dto.getActionIdMap().get(eventType))) {
            log.info("\u6295\u653e\u8ba1\u5212\u8bbe\u5b9a\u4e0d\u56de\u4f20 {},{}", (Object)channelId, (Object)eventType);
            return null;
        }
        if (RandomUtils.nextInt((int)10000) >= dto.getProbabilityBack()) {
            log.info("\u6982\u7387\u6ca1\u547d\u4e2d {},{}", (Object)channelId, (Object)eventType);
            return null;
        }
        return dto.getActionIdMap().get(eventType);
    }
}

