package cn.com.duiba.tuia.purchase.web.api.model.query;

import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @author ikongyi && zhongda
 */
public class BaseQuery implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Integer MIN_PAGE_NO = 1;
    public static final Integer DEFAULT_PAGE_NO = 1;
    public static final Integer DEFAULT_PAGE_SIZE = 20;

    private Long id;
    private Long gtId;

    private List<OrderBy> sortList;

    private Integer offset;
    private Integer pageNo;
    private Integer pageSize;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGtId() {
        return gtId;
    }

    public void setGtId(Long gtId) {
        this.gtId = gtId;
    }

    public List<OrderBy> getSortList() {
        return sortList;
    }

    public void setSortList(List<OrderBy> sortList) {
        this.sortList = sortList;
    }

    public Integer getOffset() {
        if (Objects.nonNull(offset)) {
            return offset;
        }
        if (ObjectUtils.allNotNull(pageNo, pageSize)) {
            return (pageNo - 1) * this.pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        if (Objects.isNull(pageNo) || pageNo < MIN_PAGE_NO) {
            pageNo = DEFAULT_PAGE_NO;
        }
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
