package cn.com.duiba.tuia.purchase.web.api.constant;

import java.util.Map;
import java.util.Objects;

/**
 * 基础字段
 */
public class BaseOcpcCallBackDTO {

    //行为
    public static final String A_TYPE = "a_type";
    // 广告计划id
    public static final String A_ID = "a_id";

    /**
     * 旧的渠道ID参数名
     * 需要兼容已经在投放的数据，直接重命名变量名，目前有依赖调用的工程不多
     *
     * @deprecated use {@link #CHANNEL_ID} instead.
     */
    @Deprecated
    public static final String OLD_CHANNEL_ID = "purchase_channel_id";

    /**
     * 新的渠道ID参数名（实际是任务ID）
     */
    public static final String CHANNEL_ID = "pbp_cid";

    /**
     * 计划ID
     */
    public static final String PLAN_ID = "pbp_pid";

    /**
     * 旧的媒体平台ID参数名
     * 需要兼容已经在投放的数据，直接重命名变量名，目前有依赖调用的工程不多
     *
     * @deprecated use {@link #APP_ID} instead.
     */
    @Deprecated
    public static final String OLD_APP_ID = "purchase_app_id";

    /**
     * 新的媒体平台ID参数名
     */
    public static final String APP_ID = "pbp_aid";

    public static final String PLAT_FORM = "plat_form";

    // 账户id
    public static final String ACCOUNT_ID = "accountid";

    //回传地址
    public static final String CALL_BACK = "callback";

    // OS
    public static final String OS = "os";

    // UserAgent
    public static final String USER_AGENT = "ua";

    // IP
    public static final String IP = "ip";

    public static final String IMEI = "tu_a1";
    public static final String IMEI_MD5 = "tu_a2";
    public static final String IDFA = "tu_b1";
    public static final String IDFA_MD5 = "tu_b2";
    public static final String OAID = "tu_c1";
    public static final String OAID_MD5 = "tu_c2";
    public static final String ANDROID_ID = "tu_d1";
    public static final String ANDROID_ID_MD5 = "tu_d2";
    public static final String MAC = "tu_e1";
    public static final String MAC_MD5 = "tu_e2";
    /**
     * 机型
     */
    public static final String MODEL = "model";
    /**
     * 单价
     */
    public static final String UNIT_PRICE = "o_amt1";
    /**
     * 佣金
     */
    public static final String FEE = "o_amt2";
    /**
     * 商户ID
     */
    public static final String MERCHANT_ID = "o_merid";
    /**
     * 商品ID
     */
    public static final String PRODUCT_ID = "o_itemid";

    /**
     * @deprecated use {@link #ACTION_ID} instead.
     */
    @Deprecated
    public static final String CONV_ID = "conv_id";

    /**
     * 曝光ID/点击ID
     */
    public static final String ACTION_ID = "action_id";

    /**
     * Track ID
     */
    public static final String TRACK_ID = "pbp_tid";

    /**
     * 监测链接参数名调整，兼容线上已经在投放的数据
     *
     * @param feedbackParamMap 监测链接请求参数
     * @return 渠道ID（实际是任务ID）
     */
    public static <T> T getChannelId(Map<String, T> feedbackParamMap) {
        T channelId = feedbackParamMap.get(BaseOcpcCallBackDTO.CHANNEL_ID);
        if (Objects.nonNull(channelId)) {
            return channelId;
        }
        return feedbackParamMap.get(BaseOcpcCallBackDTO.OLD_CHANNEL_ID);
    }

    /**
     * 监测链接参数名调整，兼容线上已经在投放的数据
     *
     * @param feedbackParamMap 监测链接请求参数
     * @return 应用ID（实际是媒体平台ID）
     */
    public static <T> T getAppId(Map<String, T> feedbackParamMap) {
        T appId = feedbackParamMap.get(BaseOcpcCallBackDTO.APP_ID);
        if (Objects.nonNull(appId)) {
            return appId;
        }
        return feedbackParamMap.get(BaseOcpcCallBackDTO.OLD_APP_ID);
    }

}
