package cn.com.duiba.tuia.purchase.web.api.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * @author zhongda & ikongyi
 */
public enum CpsTaskCode {
    JD("JD", "京东CPS"),
    JD_PUSH("JD_NEW", "京东cps_推送"),
    MT("MT", "美团CPS"),
    ;
    private String code;
    private String desc;

    CpsTaskCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Optional<CpsTaskCode> getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return Optional.empty();
        }
        for (CpsTaskCode item : CpsTaskCode.values()) {
            if (item.getCode().equals(code)) {
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
