package cn.com.duiba.tuia.purchase.web.api.util;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhongda & ikongyi
 */
public class PbpOrderNoUtils {

    public static final String PBP_ORDER_NO_PREFIX = "pbp-";

    /**
     * 在这里统一下外采平台的订单号规则吧，不能污染了大盘
     *
     * @param mediaPlatFormId 媒体平台ID
     * @param channelId 渠道ID（实际是任务ID）
     * @param actionId 媒体监测上报的唯一ID（impression_id/click_id）
     * @return 程序化外采平台订单号
     */
    public static String getOrderNo(String mediaPlatFormId, String channelId, String actionId) {
        StringBuilder sb = new StringBuilder();
        sb.append(PBP_ORDER_NO_PREFIX);
        sb.append(DigestUtils.sha256Hex(actionId)); // 多了一条CPS任务的路，此乃缓兵之计
        sb.append(StringUtils.leftPad(mediaPlatFormId, 5, "0"));
        sb.append(StringUtils.leftPad(channelId, 7, "0"));
        return sb.toString();
    }

    public static boolean isPbpOrderNo(String orderNo) {
        return orderNo.startsWith(PBP_ORDER_NO_PREFIX);
    }

}
