package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author songjiaxing
 * @createTime 2017/03/22
 */
public interface RemoteActivitySortService {

    /**
     * 给活动中心的提供的接口,获取推荐的活动ID列表
     * 
     * @param slotId 广告位ID
     * @return
     */
    DubboResult<List<Long>> getActivityIdForCenter(Long slotId);


    /**
     * 获取默认列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getDefaultActivityList();
    
    /**
     * 给活动推荐引擎提供查询广告活动的接口
     *
     * @param slotId 广告位ID
     * @return 活动列表
     */
    public DubboResult<List<RspActivityDto>> getActivityBySlotNew(Long slotId, Map<Integer, String> actTypeMap);
    
    /**
     * 获取引擎投放列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getEngineActivityList(Map<Integer, String> actTypeMap);
    
    /**
     * 获取试投列表
     *
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getNewActivityList(Map<Integer, String> actTypeMap);
    
    /**
     * 根据活动ID列表获取活动详情列表
     *
     * @param ids 活动ID列表
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityPlanDetailList(List<Long> ids, Map<Integer, String> actTypeMap);

    /**
     * 提供给活动中心
     * 根据source和活动列表批量修改活动推广计划开启关闭状态，任意参数为空则返回0。
     *  @param source 0 为兑吧 1 为推啊 2 为流量引导页
     *  @param ids   活动activity_id集合
     *  @param status 0 关闭 1 开启
     *  @return 返回更新记录条数
     */
    DubboResult<Integer> batchUpdateActivtyStatusBySource(List<Long> ids, Integer source,Integer status);


    /**
     * 给活动WEB使用，查询num条活动ID，id倒序
     *
     * @param source 活动来源（0：兑吧 1：推啊  2：流量引导页）
     * @param slotId   广告位id
     * @return 活动ID列表
     */
    public DubboResult<List<Long>> getActivityBySource(Integer source,Long slotId);
}
