/**
 * Project Name:media-manager-biz File Name:ReqActivitySlotDailyDataByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月26日上午9:50:08 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqActivitySlotDailyDataByPage <br/>
 * Function: 活动广告每日数据. <br/>
 * Date: 2016年12月26日 上午9:50:08 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActivitySlotDailyDataByPage extends ReqPageQuery {

    /** 序列号. */
    private static final long serialVersionUID = -2623454748555580638L;

    /** 活动ID. */
    @ApiModelProperty(value = "活动ID", required = true)
    @NotNull(message = "活动ID不能为空")
    private Long              activityId;

    /** 广告ID. */
    @ApiModelProperty(value = "广告ID", required = true)
    @NotNull(message = "广告ID不能为空")
    private Long              slotId;

    /** 开始日期. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始时间不能为空")
    private String            startDate;

    /** 结束日期. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束时间不能为空")
    private String            endDate;

    /** The activity name. */
    @ApiModelProperty(value = "活动名称(用于导出)", required = false)
    private String            activityName;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称(用于导出)", required = false)
    private String            slotName;
    
    @ApiModelProperty(value = "活动来源)", required = false)
    private Integer           source;

    
    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the activity name.
     *
     * @return the activity name
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activity name.
     *
     * @param activityName the activity name
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }
    
    /**
     * Gets the source.
     *
     * @return the source
     */
    public Integer getSource() {
        return source;
    }

    /**
     * Sets the source.
     *
     * @param source the source
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
