/**
 * Project Name:ssp-center-api
 * File Name:ReqCashParam.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年5月4日下午9:15:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName:ReqCashParam <br/>
 * Function: 请求提现参数. <br/>
 * Date:     2017年5月4日 下午9:15:27 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqCashParam implements Serializable{

    /**序列号*/
    private static final long serialVersionUID = -7918883536431233741L;
    
    /**提现金额*/
    private Long  cashAmount;

    /**联系人*/
    private String linkMan;
    
    /**联系电话*/
    private String linkPhone;
    
    /**寄件人地址*/
    private String senderAddress;
    
    /**寄件类型*/
    private Integer sendType;
    
    /**媒体提现单发票信息*/
    private List<BaseCashBillDto> invoicesList;
  
    /**媒体应用IDS*/
    private List<Long> appIds;
    
    /**账单月份集合*/
    private List<String> curDates;

    /**发票数量*/
    private Integer invoiceNum;
    
    /**媒体用户ID*/
    private Long mediaId;
    
    /**提现订单*/
    private Long cashOrderId;
    
    /**所填发票金额*/
    private Long fillInAmount;
    
    
    public Long getFillInAmount() {
        return fillInAmount;
    }

    public void setFillInAmount(Long fillInAmount) {
        this.fillInAmount = fillInAmount;
    }


    public Long getMediaId() {
        return mediaId;
    }

    
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }


    public Long getCashAmount() {
        return cashAmount;
    }

    
    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

    
    public String getLinkMan() {
        return linkMan;
    }

    
    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }

    
    public String getLinkPhone() {
        return linkPhone;
    }

    
    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }

    
    public String getSenderAddress() {
        return senderAddress;
    }

    
    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    
    public Integer getSendType() {
        return sendType;
    }

    
    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    
    
    public Integer getInvoiceNum() {
        return invoiceNum;
    }

    
    public void setInvoiceNum(Integer invoiceNum) {
        this.invoiceNum = invoiceNum;
    }
    
     
    public Long getCashOrderId() {
        return cashOrderId;
    }

    
    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }
    
    public List<BaseCashBillDto> getInvoicesList() {
        return invoicesList;
    }
    
    public void setInvoicesList(List<BaseCashBillDto> invoicesList) {
        this.invoicesList = invoicesList;
    }
    
    
    public List<Long> getAppIds() {
        return appIds;
    }

    
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }
    
    public List<String> getCurDates() {
        return curDates;
    }

    
    public void setCurDates(List<String> curDates) {
        this.curDates = curDates;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}

