/**
 * Project Name:media-manager-biz
 * File Name:ReqDayBillDetailByPage.java
 * Package Name:cn.com.duiba.tuia.media.manager.model.req
 * Date:2017年2月9日下午3:37:59
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;

/**
 * ClassName:ReqDayBillDetailByPage <br/>
 * Function: 日账单明细. <br/>
 * Date:     2017年2月9日 下午3:37:59 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqDayBillDetailByPage extends BaseQueryDto {

    /**序列号*/
    private static final long serialVersionUID = 4343600534372006093L;
    

    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;
    
    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;
    
    /**媒体ID*/
    @ApiModelProperty(value = "媒体ID", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long appId;
    
    /**广告ID*/
    @ApiModelProperty(value = "广告ID", required = false)
    private Long slotId;
    
    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param startDate the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the appId.
     *
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the appId.
     *
     * @param appId the appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the slotId.
     *
     * @return the slotId
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * Sets the slotId.
     *
     * @param slotId the slotId
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}

