/**
 * Project Name:media-manager-biz File Name:ReqActivitySoltHourDataByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月22日下午5:46:20 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqActivitySoltHourDataByPage <br/>
 * Function: 活动广告每小时数据. <br/>
 * Date: 2016年12月22日 下午5:46:20 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActivitySoltHourDataByPage extends ReqPageQuery {

    /** 序列号. */
    private static final long serialVersionUID = -7222119469225011793L;

    /** 当前日期. */
    @ApiModelProperty(value = "当前日期 ", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "当前日期不能为空")
    private String            curDate;

    /** 活动ID. */
    @ApiModelProperty(value = "活动ID", required = true)
    @NotNull(message = "活动ID不能为空")
    private Long              activityId;

    /** 广告ID. */
    @ApiModelProperty(value = "广告ID", required = false)
    private Long              slotId;

    /** The activity name. */
    @ApiModelProperty(value = "活动名称(用于导出)", required = false)
    private String            activityName;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称(用于导出)", required = false)
    private String            slotName;

    @ApiModelProperty(value = "活动来源", required = false)
    private Integer           source;
    
    /** 数据统计时间段 0:代表半小时统计一次 1:代表1小时统计一次. */
    @ApiModelProperty(value = "数据统计时间段 0:代表半小时统计一次 1:代表1小时统计一次", required = true)
    private Integer          durationType;

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the activity name.
     *
     * @return the activity name
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activity name.
     *
     * @param activityName the activity name
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }
    
    /**
     * Gets the source.
     *
     * @return the source
     */
    public Integer getSource() {
        return source;
    }


    /**
     * Sets the source.
     *
     * @param source the source
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getDurationType() {
		return durationType;
	}

	public void setDurationType(Integer durationType) {
		this.durationType = durationType;
	}

	/**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
