/**
 * Project Name:media-api File Name:ReqGetMediaAppConfigByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午2:59:53 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqGetMediaAppConfigByPageDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午2:59:53 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqGetMediaAppConfigByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = 6622615552013049824L;

    /** 按创建时间排序 */
    public static final String SORT_TYPE        = "gmt_create";

    /** 按降序排序 */
    public static final String ORDER_TYPE       = "desc";

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long               appId;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String             appName;

    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", required = false)
    private String             email;

    /** 审核状态 */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer            checkStatus;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间", required = false)
    private String             createDate;

    @ApiModelProperty(value = "线下打款状态位，0-非线下打款公司,1-线下打款公司")
    private Integer            isOffline;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
