package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: BaseStatisticsDataRsp <br/>
 * Function: 媒体、活动、广告位基础数据信息. <br/>
 * date: 2016年12月21日 上午10:17:46 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class BaseStatisticsDataRsp implements Serializable {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 8248191825484142948L;

    /** 入口曝光量. */
    private Long              actExposeCount;

    /** 入口点击量. */
    private Long              actClickCount;

    /** 入口访问量. */
    private Long              actShowCount;

    /** 曝光点击率. */
    private Float             actClickRate;

    /** 入口点击UV. */
    private Long              actClickUv;

    /** 活动参与次数. */
    private Long              participateCount;

    /** 活动参与人数. */
    private Long              participateUv;

    /** 参与率. */
    private Float             actParticipateRate;

    /** 复参数. */
    private Float             rptParticipateCount;

    /** 活动点击单价（分）. */
    private Long              actPerClickFee;

    /** 每日发券量. */
    private Long              launchCount;

    /** 发券成功率. */
    private Float             launchSuccessRate;

    /** 广告曝光量. */
    private Long              advertExposureCount;

    /** 广告点击量. */
    private Long              advertClickCount;

    /** 广告点击率. */
    private Float             advertClickRate;

    /** 广告点击单价（分）. */
    private Long              advertPerClickFee;

    /** 广告收入/广告点击量. */
    private Long              arpu;

    /** 千次曝光产生的发券. */
    private Float              spm;

    /** 千次曝光产生的广告消耗（分）. */
    private Long              ecpm;

    /** 广告消耗（分）. */
    private Long              adConsume;

    /** 媒体预计分成（分）. */
    private Long              exConsumeTotal;

    /** 媒体应得分成（分）. */
    private Long              consumeTotal;

    /** 广告位类型 */
    private Integer           slotType;

    /** 广告位规格ID */
    private Long              slotMsId;

    /** 活动请求PV */
    private Long              actRequestCount;

    /** 活动请求UV */
    private Long              actRequestUv;

    /** 活动广告券请求 */
    private Long              advertRequestCount;

    /** 请求成功率 */
    private Float             requestSuccessRate;

    /** 活动来源 0：兑吧活动 1：推啊活动 2：流量引导页 */
    private Integer           source;

    /** 流量引导页访问PV */
    private Long              flowGuidePagePv;

    /** 流量引导页访问UV */
    private Long              flowGuidePageUv;

    /** 广告请求UV */
    private Long              slotRequestPv;

    /** 广告请求PV */
    private Long              slotRequestUv;

    /** 媒体CPM */
    private Long              mediaCPM;

    /** 活动UV单价 */
    private Long              actUvPrice;

    /** 媒体活动UV单价 */
    private Long              mediaActUvPrice;

    /** 媒体点击单价 */
    private Long              mediaClickPrice;

    /** 广告位成功响应数量 */
    private Long              actSucResponseCount;

    /** accessPv:曝光pv. */
    private Long              buoyAccessPv;

    /** accessUv:曝光uv. */
    private Long              buoyAccessUv;

    /** clickPv:点击pv总和. */
    private Long              buoyClickPv;

    /** clickUv:点击uv总和. */
    private Long              buoyClickUv;

    /** 浮标到活动中心的发券. */
    private Integer           actCenterAmount;

    /** 浮标到主会场的发券. */
    private Integer           mainMeetAmount;

    /** 浮标到活动的发券. */
    private Integer           activityAmount;

    /** 返回到活动中心的发券. */
    private Integer           backActCenterAmount;

    /** 返回到主会场的发券. */
    private Integer           backMainMeetAmount;

    /** 返回到活动的发券. */
    private Integer           backActivityAmount;
    
    /** 每UV发券 = 活动发券量/广告位访问UV. */
    private Float           perUvLaunchCount;
    
    /** 活动每UV发券 = 活动发券量/活动请求UV. */
    private Float           actPerUvLaunchCount;
    
    /** 分成比例 = 媒体应得分成/广告消耗. */
    private Float           divisionProportion;
    /** 高风险发券量. */
    private Long           highriskLaunch;
    /** 高风险发券占比 = 高风险发券量/总发券量. */
    private Float           highriskProportion;

    /** 每UV券点击 = 广告券点击量/广告位访问UV. */
    private Float           perUvClickCount;

    /** 活动每UV券点击 = 广告券点击量/活动请求UV. */
    private Float           actPerUvClickCount;
    
    /**广告劵有效点击PV*/
    private Long              efClickCount;

    /** 管理员名称*/
    private List<String> managerNameList;

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }

    public Integer getBackActCenterAmount() {
        return backActCenterAmount;
    }

    public void setBackActCenterAmount(Integer backActCenterAmount) {
        this.backActCenterAmount = backActCenterAmount;
    }

    public Integer getBackMainMeetAmount() {
        return backMainMeetAmount;
    }

    public void setBackMainMeetAmount(Integer backMainMeetAmount) {
        this.backMainMeetAmount = backMainMeetAmount;
    }

    public Integer getBackActivityAmount() {
        return backActivityAmount;
    }

    public void setBackActivityAmount(Integer backActivityAmount) {
        this.backActivityAmount = backActivityAmount;
    }

    public Float getPerUvClickCount() {
        return perUvClickCount;
    }

    public void setPerUvClickCount(Float perUvClickCount) {
        this.perUvClickCount = perUvClickCount;
    }

    public Float getActPerUvClickCount() {
        return actPerUvClickCount;
    }

    public void setActPerUvClickCount(Float actPerUvClickCount) {
        this.actPerUvClickCount = actPerUvClickCount;
    }

    /**
     * slotMsId.
     *
     * @return the slotMsId
     * @since JDK 1.6
     */
    public Long getSlotMsId() {
        return slotMsId;
    }

    /**
     * slotMsId.
     *
     * @param slotMsId the slotMsId to set
     * @since JDK 1.6
     */
    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    /**
     * actRequestCount.
     *
     * @return the actRequestCount
     * @since JDK 1.6
     */
    public Long getActRequestCount() {
        return actRequestCount;
    }

    /**
     * actRequestCount.
     *
     * @param actRequestCount the actRequestCount to set
     * @since JDK 1.6
     */
    public void setActRequestCount(Long actRequestCount) {

        this.actRequestCount = actRequestCount;
    }

    /**
     * actRequestUv.
     *
     * @return the actRequestUv
     * @since JDK 1.6
     */
    public Long getActRequestUv() {
        return actRequestUv;
    }

    /**
     * actRequestUv.
     *
     * @param actRequestUv the actRequestUv to set
     * @since JDK 1.6
     */
    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    /**
     * advertRequestCount.
     *
     * @return the advertRequestCount
     * @since JDK 1.6
     */
    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    /**
     * advertRequestCount.
     *
     * @param advertRequestCount the advertRequestCount to set
     * @since JDK 1.6
     */
    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    /**
     * requestSuccessRate.
     *
     * @return the requestSuccessRate
     * @since JDK 1.6
     */
    public Float getRequestSuccessRate() {
        return requestSuccessRate;
    }

    /**
     * requestSuccessRate.
     *
     * @param requestSuccessRate the requestSuccessRate to set
     * @since JDK 1.6
     */
    public void setRequestSuccessRate(Float requestSuccessRate) {
        this.requestSuccessRate = requestSuccessRate;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * Gets the act expose count.
     *
     * @return the act expose count
     */
    public Long getActExposeCount() {
        return actExposeCount;
    }

    /**
     * Sets the act expose count.
     *
     * @param actExposeCount the act expose count
     */
    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    /**
     * Gets the act click count.
     *
     * @return the act click count
     */
    public Long getActClickCount() {
        return actClickCount;
    }

    /**
     * Sets the act click count.
     *
     * @param actClickCount the act click count
     */
    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    /**
     * Gets the act click rate.
     *
     * @return the act click rate
     */
    public Float getActClickRate() {
        return actClickRate;
    }

    /**
     * Sets the act click rate.
     *
     * @param actClickRate the act click rate
     */
    public void setActClickRate(Float actClickRate) {
        this.actClickRate = actClickRate;
    }

    /**
     * Gets the act show count.
     *
     * @return the act show count
     */
    public Long getActShowCount() {
        return actShowCount;
    }

    /**
     * Sets the act show count.
     *
     * @param actShowCount the act show count
     */
    public void setActShowCount(Long actShowCount) {
        this.actShowCount = actShowCount;
    }

    /**
     * Gets the act click uv.
     *
     * @return the act click uv
     */
    public Long getActClickUv() {
        return actClickUv;
    }

    /**
     * Sets the act click uv.
     *
     * @param actClickUv the act click uv
     */
    public void setActClickUv(Long actClickUv) {
        this.actClickUv = actClickUv;
    }

    /**
     * Gets the participate count.
     *
     * @return the participate count
     */
    public Long getParticipateCount() {
        return participateCount;
    }

    /**
     * Sets the participate count.
     *
     * @param participateCount the participate count
     */
    public void setParticipateCount(Long participateCount) {
        this.participateCount = participateCount;
    }

    /**
     * Gets the participate uv.
     *
     * @return the participate uv
     */
    public Long getParticipateUv() {
        return participateUv;
    }

    /**
     * Sets the participate uv.
     *
     * @param participateUv the participate uv
     */
    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    /**
     * Gets the act participate rate.
     *
     * @return the act participate rate
     */
    public Float getActParticipateRate() {
        return actParticipateRate;
    }

    /**
     * Sets the act participate rate.
     *
     * @param actParticipateRate the act participate rate
     */
    public void setActParticipateRate(Float actParticipateRate) {
        this.actParticipateRate = actParticipateRate;
    }

    /**
     * Gets the rpt participate count.
     *
     * @return the rpt participate count
     */
    public Float getRptParticipateCount() {
        return rptParticipateCount;
    }

    /**
     * Sets the rpt participate count.
     *
     * @param rptParticipateCount the rpt participate count
     */
    public void setRptParticipateCount(Float rptParticipateCount) {
        this.rptParticipateCount = rptParticipateCount;
    }

    /**
     * Gets the act per click fee.
     *
     * @return the act per click fee
     */
    public Long getActPerClickFee() {
        return actPerClickFee;
    }

    /**
     * Sets the act per click fee.
     *
     * @param actPerClickFee the act per click fee
     */
    public void setActPerClickFee(Long actPerClickFee) {
        this.actPerClickFee = actPerClickFee;
    }

    /**
     * Gets the launch count.
     *
     * @return the launch count
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * Sets the launch count.
     *
     * @param launchCount the launch count
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * Gets the launch success rate.
     *
     * @return the launch success rate
     */
    public Float getLaunchSuccessRate() {
        return launchSuccessRate;
    }

    /**
     * Sets the launch success rate.
     *
     * @param launchSuccessRate the launch success rate
     */
    public void setLaunchSuccessRate(Float launchSuccessRate) {
        this.launchSuccessRate = launchSuccessRate;
    }

    /**
     * Gets the advert exposure count.
     *
     * @return the advert exposure count
     */
    public Long getAdvertExposureCount() {
        return advertExposureCount;
    }

    /**
     * Sets the advert exposure count.
     *
     * @param advertExposureCount the advert exposure count
     */
    public void setAdvertExposureCount(Long advertExposureCount) {
        this.advertExposureCount = advertExposureCount;
    }

    /**
     * Gets the advert click count.
     *
     * @return the advert click count
     */
    public Long getAdvertClickCount() {
        return advertClickCount;
    }

    /**
     * Sets the advert click count.
     *
     * @param advertClickCount the advert click count
     */
    public void setAdvertClickCount(Long advertClickCount) {
        this.advertClickCount = advertClickCount;
    }

    /**
     * Gets the advert click rate.
     *
     * @return the advert click rate
     */
    public Float getAdvertClickRate() {
        return advertClickRate;
    }

    /**
     * Sets the advert click rate.
     *
     * @param advertClickRate the advert click rate
     */
    public void setAdvertClickRate(Float advertClickRate) {
        this.advertClickRate = advertClickRate;
    }

    /**
     * Gets the advert per click fee.
     *
     * @return the advert per click fee
     */
    public Long getAdvertPerClickFee() {
        return advertPerClickFee;
    }

    /**
     * Sets the advert per click fee.
     *
     * @param advertPerClickFee the advert per click fee
     */
    public void setAdvertPerClickFee(Long advertPerClickFee) {
        this.advertPerClickFee = advertPerClickFee;
    }

    /**
     * Gets the arpu.
     *
     * @return the arpu
     */
    public Long getArpu() {
        return arpu;
    }

    /**
     * Sets the arpu.
     *
     * @param arpu the arpu
     */
    public void setArpu(Long arpu) {
        this.arpu = arpu;
    }

    /**
     * Gets the spm.
     *
     * @return the spm
     */
    public Float getSpm() {
        return spm;
    }

    /**
     * Sets the spm.
     *
     * @param spm the spm
     */
    public void setSpm(Float spm) {
        this.spm = spm;
    }

    /**
     * Gets the ecpm.
     *
     * @return the ecpm
     */
    public Long getEcpm() {
        return ecpm;
    }

    /**
     * Sets the ecpm.
     *
     * @param ecpm the ecpm
     */
    public void setEcpm(Long ecpm) {
        this.ecpm = ecpm;
    }

    /**
     * Gets the ad consume.
     *
     * @return the ad consume
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * Sets the ad consume.
     *
     * @param adConsume the ad consume
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }

    /**
     * Gets the ex consume total.
     *
     * @return the ex consume total
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * Sets the ex consume total.
     *
     * @param exConsumeTotal the ex consume total
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * Gets the consume total.
     *
     * @return the consume total
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * Sets the consume total.
     *
     * @param consumeTotal the consume total
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * Gets the source.
     *
     * @return the source
     */
    public Integer getSource() {
        return source;
    }

    /**
     * Sets the source.
     *
     * @param source the source
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * Gets the flowGuidePagePv.
     *
     * @return the flowGuidePagePv
     */
    public Long getFlowGuidePagePv() {
        return flowGuidePagePv;
    }

    /**
     * Sets the flowGuidePagePv.
     *
     * @param flowGuidePagePv the flowGuidePagePv
     */
    public void setFlowGuidePagePv(Long flowGuidePagePv) {
        this.flowGuidePagePv = flowGuidePagePv;
    }

    /**
     * Gets the flowGuidePageUv.
     *
     * @return the flowGuidePageUv
     */
    public Long getFlowGuidePageUv() {
        return flowGuidePageUv;
    }

    /**
     * Sets the flowGuidePageUv.
     *
     * @param flowGuidePageUv the flowGuidePageUv
     */
    public void setFlowGuidePageUv(Long flowGuidePageUv) {
        this.flowGuidePageUv = flowGuidePageUv;
    }

    /**
     * Gets the slotRequestPv.
     *
     * @return the slotRequestPv
     */
    public Long getSlotRequestPv() {
        return slotRequestPv;
    }

    /**
     * Sets the slotRequestPv.
     *
     * @param slotRequestPv the slotRequestPv
     */
    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    /**
     * Gets the slotRequestUv.
     *
     * @return the slotRequestUv
     */
    public Long getSlotRequestUv() {
        return slotRequestUv;
    }

    /**
     * Sets the slotRequestUv.
     *
     * @param slotRequestUv the slotRequestUv
     */
    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

    /**
     * Gets the mediaCPM.
     *
     * @return the mediaCPM
     */
    public Long getMediaCPM() {
        return mediaCPM;
    }

    /**
     * Sets the mediaCPM.
     *
     * @param mediaCPM the mediaCPM
     */
    public void setMediaCPM(Long mediaCPM) {
        this.mediaCPM = mediaCPM;
    }

    /**
     * Gets the actUvPrice.
     *
     * @return the actUvPrice
     */
    public Long getActUvPrice() {
        return actUvPrice;
    }

    /**
     * Sets the actUvPrice.
     *
     * @param actUvPrice the actUvPrice
     */
    public void setActUvPrice(Long actUvPrice) {
        this.actUvPrice = actUvPrice;
    }

    /**
     * Gets the mediaActUvPrice.
     *
     * @return the mediaActUvPrice
     */
    public Long getMediaActUvPrice() {
        return mediaActUvPrice;
    }

    /**
     * Sets the mediaActUvPrice.
     *
     * @param mediaActUvPrice the mediaActUvPrice
     */
    public void setMediaActUvPrice(Long mediaActUvPrice) {
        this.mediaActUvPrice = mediaActUvPrice;
    }

    /**
     * Gets the mediaClickPrice.
     *
     * @return the mediaClickPrice
     */
    public Long getMediaClickPrice() {
        return mediaClickPrice;
    }

    /**
     * Sets the mediaActUvPrice.
     *
     * @param mediaActUvPrice the mediaClickPrice
     */
    public void setMediaClickPrice(Long mediaClickPrice) {
        this.mediaClickPrice = mediaClickPrice;
    }

    /**
     * Gets the actSucResponseCount.
     *
     * @return the actSucResponseCount
     */
    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    /**
     * Sets the actSucResponseCount.
     *
     * @param actSucResponseCount the actSucResponseCount
     */
    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }

    public Long getBuoyAccessPv() {
        return buoyAccessPv;
    }


    public void setBuoyAccessPv(Long buoyAccessPv) {
        this.buoyAccessPv = buoyAccessPv;
    }


    public Long getBuoyAccessUv() {
        return buoyAccessUv;
    }


    public void setBuoyAccessUv(Long buoyAccessUv) {
        this.buoyAccessUv = buoyAccessUv;
    }


    public Long getBuoyClickPv() {
        return buoyClickPv;
    }


    public void setBuoyClickPv(Long buoyClickPv) {
        this.buoyClickPv = buoyClickPv;
    }


    public Long getBuoyClickUv() {
        return buoyClickUv;
    }


    public void setBuoyClickUv(Long buoyClickUv) {
        this.buoyClickUv = buoyClickUv;
    }


    public Integer getActCenterAmount() {
        return actCenterAmount;
    }


    public void setActCenterAmount(Integer actCenterAmount) {
        this.actCenterAmount = actCenterAmount;
    }


    public Integer getMainMeetAmount() {
        return mainMeetAmount;
    }


    public void setMainMeetAmount(Integer mainMeetAmount) {
        this.mainMeetAmount = mainMeetAmount;
    }


    public Integer getActivityAmount() {
        return activityAmount;
    }


    public void setActivityAmount(Integer activityAmount) {
        this.activityAmount = activityAmount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

	public Float getPerUvLaunchCount() {
		return perUvLaunchCount;
	}

	public void setPerUvLaunchCount(Float perUvLaunchCount) {
		this.perUvLaunchCount = perUvLaunchCount;
	}

	public Float getActPerUvLaunchCount() {
		return actPerUvLaunchCount;
	}

	public void setActPerUvLaunchCount(Float actPerUvLaunchCount) {
		this.actPerUvLaunchCount = actPerUvLaunchCount;
	}

	public Float getDivisionProportion() {
		return divisionProportion;
	}

	public void setDivisionProportion(Float divisionProportion) {
		this.divisionProportion = divisionProportion;
	}

	public Float getHighriskProportion() {
		return highriskProportion;
	}

	public void setHighriskProportion(Float highriskProportion) {
		this.highriskProportion = highriskProportion;
	}

	public Long getHighriskLaunch() {
		return highriskLaunch;
	}

	public void setHighriskLaunch(Long highriskLaunch) {
		this.highriskLaunch = highriskLaunch;
	}

}
