package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class ReqNoticeDto extends ReqPageQuery {

	private static final long serialVersionUID = -5439911255537604104L;

	@ApiModelProperty(value = "通知标题")
	private String title;

	@ApiModelProperty(value = "通知id列表")
	private List<Long> noticeIds;

	@ApiModelProperty(value = "媒体id")
	private Long mediaId;

	@ApiModelProperty(value = "媒体创建时间")
	private Date createTime;

	/** The start date. */
    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    /** The end date. */
    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;


	private String mediaIdAddComma;
    
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public List<Long> getNoticeIds() {
		return noticeIds;
	}

	public void setNoticeIds(List<Long> noticeIds) {
		this.noticeIds = noticeIds;
	}

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getMediaIdAddComma() {
		return mediaIdAddComma;
	}

	public void setMediaIdAddComma(String mediaIdAddComma) {
		this.mediaIdAddComma = mediaIdAddComma;
	}
}
