package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaRewardStrategyService {

    public DubboResult<Integer> addRewardStrategy(RewardStrategyDto strategyDto);


    public DubboResult<Integer> addBatchRewardStrategy(List<RewardStrategyDto> dtoList);

    public DubboResult<Integer> delRewardStrategy(Long id);

    public DubboResult<Integer> updateRewardStrategy(RewardStrategyDto strategyDto);

    public DubboResult<List<RewardStrategyDto>> listOfRewardStrategy(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<RewardStrategyDto> findRSDById(Long id);

    public DubboResult<Integer> countOfRewardStrategy(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<RSMonthPageDto> pageListOfRewardStrategy(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<List<MediaRewardStrategyDto>> selectMRSByStrategy(List<Long> mrsIds);

    public DubboResult<Integer> addMrs(Long rsId, Long mediaId);

    public DubboResult<Integer> addMrsList(Long rsId, List<Long> mediaIds);

    public DubboResult<Integer> delMrs(Long rsId, Long mediaId);

    public DubboResult<PageResultDto<MediaRewardScoreDayDto>> listMRSD(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<PageResultDto<MediaRewardScoreDayDto>> listMRSDAdd(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<PageResultDto<MediaRewardScoreMonthDto>> pageList(ReqMediaRewardScoreMonth rewardScoreMonth);

    public DubboResult<MediaRewardSettleResult> rewardSettlementSuc(MediaRewardScoreMonthDto scoreMonthDto);

    public DubboResult<Integer> rewardSettlementFailed(MediaRewardScoreMonthDto scoreMonthDto);

    public DubboResult<Integer> rewardAuditSuc(MediaRewardScoreMonthDto scoreMonthDto);

    public DubboResult<Integer> rewardAuditFailed(MediaRewardScoreMonthDto scoreMonthDto);

    public DubboResult<Long> computeRewardByScore(Long mrsMonthId, Double score);

    public DubboResult<MediaRewardDataDto> getMediaRewardInfo(Long mediaId);

    public DubboResult<List<RewardStrategyDto>> selectRewardStrategyDtoByMonth(String curMonths);

    public DubboResult<List<MediaRewardScoreMonthDto>> listNotCash(Long mediaId);

    public DubboResult<List<MediaRewardScoreMonthDto>> listByCashOrderId(Long cashOrderId);

    public DubboResult<Integer> cash(Long cashOrderId, List<Long> ids);

    public DubboResult<List<MediaRewardScoreMonthDto>> listByCashs(List<Long> cashOrderIds);
    
    public DubboResult<List<MediaRewardStrategyDto>> listMRSDByMonthAndMids(String curMonth, List<Long> mediaIds);
    
    public DubboResult<List<RewardStrategyDto>> listRSDByNameAndMonth(String name, String curMonth);
    
    public DubboResult<PageResultDto<MediaRewardScoreMonthDto> > listAuditedByMediaId(ReqMediaRewardScoreMonth reqMediaRewardScoreMonth);
}
