package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.NoticeAccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.NoticeDto;
import cn.com.duiba.tuia.ssp.center.api.dto.NoticeMediaDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqNoticeAccount;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqNoticeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 通知中心dubbo接口
 * 
 * @author songjiaxing
 *
 */
@AdvancedFeignClient
public interface RemoteNoticeService {

	/**
	 * 添加新通知
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> insertNotice(NoticeDto noticeDto);

	/**
	 * 更新通知 只更新为发送的通知
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> updateNotice(NoticeDto noticeDto);

	/**
	 * 列表查询通知
	 * 
	 * @param params:{'title':通知标题（模糊查询）,'start':开始时间,'end':结束时间,'ids':媒体接收通知列表（
	 *            in）}
	 * @return
	 */
	public DubboResult<List<NoticeDto>> listNotice(ReqNoticeDto params);

	/**
	 * 查询列表总数
	 * 
	 * @param params
	 * @return
	 */
	public DubboResult<Integer> listNoticeAmount(ReqNoticeDto params);

	/**
	 * 媒体查询通知列表并接收通知(用于弹窗提醒)
	 * 
	 * @param params:{'createTime'
	 *            : 媒体创建时间,'mediaId':媒体id,'ids':已接受通知id列表（not in）}
	 * @return
	 */
	public DubboResult<List<NoticeDto>> listByMedia(ReqNoticeDto params);

	/**
	 * 根据id查询通知信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<NoticeDto> findNoticeById(Long id);

	/**
	 * 根据id查询通知信息for复制功能
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<NoticeDto> findNoticeById4Copy(Long id);

	/**
	 * 媒体更新通知状态为已读
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> update2read(Long mediaId, Long noticeId);

	/**
	 * 媒体更新通知状态为删除
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> update2del(Long mediaId, Long noticeId);

	/**
	 * 根据mediaId查询媒体已接受通知Id列表(提示使用,包含用户删除的通知)
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<Long>> listNidByMedia4tip(Long mediaId);

	/**
	 * 根据mediaId查询媒体已接受通知Id列表(列表使用，不包含用户删除的通知)
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<NoticeMediaDto>> listNidByMedia4list(Long mediaId);

	/**
	 * 媒体接收通知
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<NoticeDto>> reviceNotices(Long mediaId);

	/**
	 * 获取媒体未读通知数量
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<Integer> countUnread(Long mediaId);

	/**
	 * 查询媒体账户列表
	 * 
	 * @param reqNoticeAccount
	 * @return
	 */
	public DubboResult<List<NoticeAccountDto>> listNoticeAccount(ReqNoticeAccount reqNoticeAccount);
	
	/**
	 * 逻辑删除通知（管理平台使用）
	 * @param id
	 * @return
	 */
	public DubboResult<Integer> delNotice(Long id);
	
	/**
	 * 获取下一封通知（媒体详情使用）
	 * @param mediaId 媒体id
	 * @param nid 当前通知id
	 * @return
	 */
	public DubboResult<NoticeDto>  findNextByMediaIdAndNid(Long mediaId, Long nid);
}
