/**
 * Project Name:media-api File Name:ReqAccountMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年11月30日下午5:08:53 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqAccountMonthReportDto <br/>
 * Function: 用户月报表分页dto. <br/>
 * Date: 2016年11月30日 下午5:08:53 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqAccountMonthReportByPage extends BaseQueryDto {

    /** 序列号 */
    private static final long serialVersionUID = -7607047345088496835L;

    /** 结算状态 */
    @ApiModelProperty(value = "结算状态", required = false)
    private Integer           checkStatus;

    /** 审核状态 */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer           auditStatus;
    
    /** 媒体用户账号 */
    @ApiModelProperty(value = "媒体用户账号", required = false)
    private String            account;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 当前日期 */
    @ApiModelProperty(value = "当前日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "当前日期不能为空")
    private String            currentDate;

    /** 账户类型：0-普通账户 1-线下打款账户 */
    @ApiModelProperty(value = "是否是线下打款账户", required = false)
    private Integer             isOffline;


    /** 开发者ID */
    @ApiModelProperty(value = "开发者ID", required = false)
    private Integer             mediaId;

    private String              conditionStr;

    /**用户类别*/
    @ApiModelProperty(value = "用户类别", required = false)
    private Integer accountType;
    
    /**媒体账户ids*/
    @ApiModelProperty(value = "媒体账户ids", required = false)
    private List<Long> mediaIds;
    /**媒体ids*/
    @ApiModelProperty(value = "媒体ids", required = false)
    private List<Long> appIds;


    /**
     * currentDate.
     *
     * @return the currentDate
     * @since JDK 1.6
     */
    public String getCurrentDate() {
        return currentDate;
    }

    /**
     * currentDate.
     *
     * @param currentDate the currentDate to set
     * @since JDK 1.6
     */
    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    /**
     * account.
     *
     * @return the account
     * @since JDK 1.6
     */
    public String getAccount() {
        return account;
    }

    /**
     * account.
     *
     * @param account the account to set
     * @since JDK 1.6
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Integer getMediaId() {
        return mediaId;
    }

    public void setMediaId(Integer mediaId) {
        this.mediaId = mediaId;
    }

    public String getConditionStr() {
        return conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }
    
    public Integer getAccountType() {
        return accountType;
    }

    
    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    
    public List<Long> getMediaIds() {
        return mediaIds;
    }

    
    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }
    
    public List<Long> getAppIds() {
        return appIds;
    }

    
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
