/**
 * 
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;

/**
 * 此类描述的是： 分页查询条件
 * 
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
public class BaseQueryDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 每页10条记录. */
    public static final int   PAGE_SIZE_10     = 10;

    /** 每页20条记录. */
    public static final int   PAGE_SIZE_20     = 20;

    /** 每页50条记录. */
    public static final int   PAGE_SIZE_50     = 50;

    /** 最大每页记录数(10000条). */
    public static final int   PAGE_SIZE_MAX    = 10000;

    /** 起始记录数. */
    private int               rowStart         = 0;

    /** 当前页. */
    private int               currentPage      = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    private Integer           pageSize;

    /** 排序字段. */
    private String            sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String            order;
    
    /**总计查询*/
    public static final int TOTAL_QUERY=1;
    
    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;
    
    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long>      managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;
    
    /**总计查询*/
    @ApiModelProperty(value = "总计查询", required = false)
    private Integer         totalQuery;

    
    public Integer getTotalQuery() {
        return totalQuery;
    }

    
    public void setTotalQuery(Integer totalQuery) {
        this.totalQuery = totalQuery;
    }

    public int getRowStart() {
        return rowStart;
    }

    public void setRowStart(int rowStart) {
        this.rowStart = rowStart;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseQueryDto [rowStart=");
        builder.append(rowStart);
        builder.append(", currentPage=");
        builder.append(currentPage);
        builder.append(", pageSize=");
        builder.append(pageSize);
        builder.append(", sort=");
        builder.append(sort);
        builder.append(", order=");
        builder.append(order);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

	public Long getManagerId() {
		return managerId;
	}

	public void setManagerId(Long managerId) {
		this.managerId = managerId;
	}

	public List<Long> getManagerAppIds() {
		return managerAppIds;
	}

	public void setManagerAppIds(List<Long> managerAppIds) {
		this.managerAppIds = managerAppIds;
	}

    public List<Long> getManagerMediaIds() {
        return managerMediaIds;
    }

    public void setManagerMediaIds(List<Long> managerMediaIds) {
        this.managerMediaIds = managerMediaIds;
    }
}
