package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DyhAdvertPushDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDyhAdvertPushDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDyhApplyDirectional;

/**
 * ClassName: RemoteDyhAdvertPushService <br/>
 * Function: <br/>
 * Date: 2018年06月29日 下午5:04 <br/>
 *
 * @author lijian
 */
@AdvancedFeignClient
public interface RemoteDyhAdvertPushService {

    /***
     * 更新大运河广告推荐信息及广告定向申请记录
     * 
     * @param dto
     * @return
     */
    Boolean updateDyhAdvertPush(DyhAdvertPushDto dto);

    /***
     * 分页查询大运河广告推荐信息列表，
     * 
     * @param req
     * @return
     */
    PageResultDto<DyhAdvertPushDto> listDyhAdvertPushByLimit(ReqDyhAdvertPushDto req);


    /***
     * 广告定向推荐
     *
     * @param req
     * @return
     */
    Boolean applyDirectional(ReqDyhApplyDirectional req);


}
