package cn.com.duiba.tuia.ssp.center.api.dto;


import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqUpdateSlotDailyData <br/>
 * Function: 修改广告位日统计数据. <br/>
 * Date: 2017年4月5日 下午4:39:53 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateSlotDailyData implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 5803800172841873863L;

    /** id */
    @ApiModelProperty(value = "id", required = true)
    @NotNull(message = "id不能为空")
    private Long              id;

    /** 广告位曝光PV */
    @ApiModelProperty(value = "广告位曝光PV", required = false)
    private Long              slotExposePv;

    /** 广告位点击PV */
    @ApiModelProperty(value = "广告位点击PV", required = false)
    private Long              slotClickPv;

    /** 广告位点击UV */
    @ApiModelProperty(value = "广告位点击UV", required = false)
    private Long              slotClickUv;
    
    /**广告位UV单价*/
    @ApiModelProperty(value = "广告位UV单价", required = false)
    private Long              slotUvPrice;
    
    /**广告位计费类型*/
    @ApiModelProperty(value = "广告位计费类型", required = false)
    private Integer           chargeType;

    

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.6
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.6
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * slotExposePv.
     *
     * @return the slotExposePv
     * @since JDK 1.6
     */
    public Long getSlotExposePv() {
        return slotExposePv;
    }

    /**
     * slotExposePv.
     *
     * @param slotExposePv the slotExposePv to set
     * @since JDK 1.6
     */
    public void setSlotExposePv(Long slotExposePv) {
        this.slotExposePv = slotExposePv;
    }

    /**
     * slotClickPv.
     *
     * @return the slotClickPv
     * @since JDK 1.6
     */
    public Long getSlotClickPv() {
        return slotClickPv;
    }

    /**
     * slotClickPv.
     *
     * @param slotClickPv the slotClickPv to set
     * @since JDK 1.6
     */
    public void setSlotClickPv(Long slotClickPv) {
        this.slotClickPv = slotClickPv;
    }

    /**
     * slotClickUv.
     *
     * @return the slotClickUv
     * @since JDK 1.6
     */
    public Long getSlotClickUv() {
        return slotClickUv;
    }

    /**
     * slotClickUv.
     *
     * @param slotClickUv the slotClickUv to set
     * @since JDK 1.6
     */
    public void setSlotClickUv(Long slotClickUv) {
        this.slotClickUv = slotClickUv;
    }
   
    public Long getSlotUvPrice() {
        return slotUvPrice;
    }

    
    public void setSlotUvPrice(Long slotUvPrice) {
        this.slotUvPrice = slotUvPrice;
    }
    
    public Integer getChargeType() {
        return chargeType;
    }

    
    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
