package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaAccount;
import cn.com.duiba.tuia.ssp.center.api.dto.common.IdAndTypeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountService {

    DubboResult<Integer> insert(AccountDto accountDto);

    DubboResult<AccountDto> selectByPhone(String phone);

    DubboResult<Integer> updateEmail(String email, Long mediaId);

    DubboResult<Integer> updatePasswdByEmail(String password, String email);

    DubboResult<Integer> updateEmailStatus(Integer status, Long mediaId);

    DubboResult<Integer> updateRoleType(Integer roleType, Long mediaId);

    DubboResult<Integer> updateAccount(String companyName, String linkman, Long mediaId);

    DubboResult<Integer> updatePhoneNum(String phoneNum, Long mediaId);

    DubboResult<Integer> selectFirstEnterStatus(Long mediaId);

    DubboResult<Integer> updateFirstEnterStatus(Long mediaId);

    /**
     * 
     * updateIsOffline:(修改媒体账号设置). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateIsOffline(ReqUpdateMediaAccount param);
    
    /**
     * 
     * selectMediaIdAndType:(查询媒体账户ID和媒体账户类型). <br/>
     *
     * @author guyan
     * @param accountType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<IdAndTypeDto>> selectMediaIdAndType(Integer accountType);
    
    /**
     * 
     * selectMediaIdAndTypeByIds:(查询媒体账户ID和媒体账户类型通过媒体ids). <br/>
     *
     * @author guyan
     * @param mediaIds
     * @return
     * @since JDK 1.6
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<IdAndTypeDto>> selectMediaIdAndTypeByIds(List<Long> mediaIds);

    Long selectFirstRewardStatus(Long mediaId);



            int updateFirstRewardStatus(Long mediaId);

    /**
     * 更新媒体条款状态
     *
     * @param mediaId
     * @return
     */
    int updateTermsStatus(Long mediaId);

    List<AccountDto> selectByMediaIds(List<Long> mediaIds);

}
