/**
 * Project Name:media-api File Name:ReqCreateMediaAppConfigDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午5:41:18 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqCreateMediaAppConfigDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午5:41:18 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqUpdateMediaAppConfigDto implements Serializable {

    /** 序列号 */
    private static final long   serialVersionUID         = 553359720571905746L;

    /** 计费方式分成 */
    public static final Integer CHARGE_TYPE_DIVIDED_INTO = 0;

    /** 计费方式CPC */
    public static final Integer CHARGE_TYPE_CPC          = 1;

    /** 计费方式CPM */
    public static final Integer CHARGE_TYPE_CPM          = 2;

    /** 扣量 */
    public static final boolean IS_DEDUCTED              = true;

    /** 不扣量 */
    public static final boolean NO_DEDUCTED              = false;

    /** 媒体Id */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long                appId;

    /** 计费方式:0-分成； 1-CPC; 2-CPM; */
    @ApiModelProperty(value = "计费方式", required = true)
    @NotNull(message = "计费方式不能为空")
    @Min(value = 0, message = "计费方式选择错误")
    @Max(value = 2, message = "计费方式选择错误")
    private Integer             chargeType;

    /** 价格 */
    @ApiModelProperty(value = "价格", required = false)
    private Long                price;

    /** 媒体分账比例 */
    @ApiModelProperty(value = "媒体分账比例", required = false)
    private Integer              mediaSplitRatio;

    /** 平台分账比例 */
    @ApiModelProperty(value = "平台分账比例", required = false)
    private Integer              platformSplitRatio;

    /** 是否扣量字段前段传递默认不扣量值 2017-01-02 zfz */

    /** 0-不扣量;1-扣量;默认为1-扣量 */
    @ApiModelProperty(value = "扣量", required = true)
    private Boolean             isDeducted;

    /** 扣量比例：% */
    @ApiModelProperty(value = "扣量比例", required = false)
    private Integer             deductedPercent;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Integer getMediaSplitRatio() {
        return mediaSplitRatio;
    }

    public void setMediaSplitRatio(Integer mediaSplitRatio) {
        this.mediaSplitRatio = mediaSplitRatio;
    }

    public Boolean getIsDeducted() {
        return isDeducted;
    }

    public void setIsDeducted(Boolean isDeducted) {
        this.isDeducted = isDeducted;
    }

    public Integer getPlatformSplitRatio() {
        return platformSplitRatio;
    }

    public void setPlatformSplitRatio(Integer platformSplitRatio) {
        this.platformSplitRatio = platformSplitRatio;
    }

    public Integer getDeductedPercent() {
        return deductedPercent;
    }

    public void setDeductedPercent(Integer deductedPercent) {
        this.deductedPercent = deductedPercent;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
