/**
 * Project Name:ssp-center-api
 * File Name:ManagerShieldStrategyDto.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年8月17日下午4:36:35
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.List;

/**
 * ClassName:ManagerShieldStrategyDto <br/>
 * Function: 管理端屏蔽策略. <br/>
 * Date:     2017年8月17日 下午4:36:35 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ManagerShieldStrategyDto extends BaseDto{

    /**序列号*/
    private static final long serialVersionUID = -8829746712300411032L;
    
    /**管理端屏蔽行业标签 类型*/
    public static final int   MANAGER_SHIELD_INDUSTRIES_TYPE=1;
    
    /**管理端屏蔽广告主url标签 类型*/
    public static final int   MANAGER_SHIELD_URLS_TYPE=2;
    
    /** 屏蔽行业列表，中间以逗号隔开. */
    private String            shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    private String            advertTagNums;

    /** 屏蔽落地页标签，中间以逗号隔开. */
    private String            promoteTagNums;

    /*** 屏蔽素材标签，中间以逗号隔开.*/
    private String            materialTagNums;

    /** 不可见行业列表，中间以逗号隔开. */
    private String            invisibleIndustries;

    /** 不可见广告列表，中间以逗号隔开. */
    private String            invisibleAdvertTagNums;

    /** 不可见落地页标签，中间以逗号隔开. */
    private String            invisiblePromoteTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    private String            shieldUrls;

    /** 屏蔽活动列表， 中间以逗号隔开. */
    private String            shieldActivitys;

    /** 广告位ID */
    private Long              slotId;

    /**
     * 流量策略选中行业标签
     */
    private String selectedTags;
    
    /**更新标志*/
    private int               updateFlag;

    private String platform;

    private List<String> shieldSlotMaterialTags;

    public int getUpdateFlag() {
        return updateFlag;
    }


    
    public void setUpdateFlag(int updateFlag) {
        this.updateFlag = updateFlag;
    }


    public String getShieldIndustries() {
        return shieldIndustries;
    }

    
    public void setShieldIndustries(String shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    
    public String getAdvertTagNums() {
        return advertTagNums;
    }

    
    public void setAdvertTagNums(String advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    
    public String getShieldUrls() {
        return shieldUrls;
    }

    
    public void setShieldUrls(String shieldUrls) {
        this.shieldUrls = shieldUrls;
    }

    
    public String getShieldActivitys() {
        return shieldActivitys;
    }

    
    public void setShieldActivitys(String shieldActivitys) {
        this.shieldActivitys = shieldActivitys;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

	public String getPromoteTagNums() {
		return promoteTagNums;
	}

	public void setPromoteTagNums(String promoteTagNums) {
		this.promoteTagNums = promoteTagNums;
	}

	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getInvisibleIndustries() {
        return invisibleIndustries;
    }

    public void setInvisibleIndustries(String invisibleIndustries) {
        this.invisibleIndustries = invisibleIndustries;
    }

    public String getInvisibleAdvertTagNums() {
        return invisibleAdvertTagNums;
    }

    public void setInvisibleAdvertTagNums(String invisibleAdvertTagNums) {
        this.invisibleAdvertTagNums = invisibleAdvertTagNums;
    }

    public String getInvisiblePromoteTagNums() {
        return invisiblePromoteTagNums;
    }

    public void setInvisiblePromoteTagNums(String invisiblePromoteTagNums) {
        this.invisiblePromoteTagNums = invisiblePromoteTagNums;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getSelectedTags() {
        return selectedTags;
    }

    public void setSelectedTags(String selectedTags) {
        this.selectedTags = selectedTags;
    }

    public String getMaterialTagNums() {
        return materialTagNums;
    }

    public void setMaterialTagNums(String materialTagNums) {
        this.materialTagNums = materialTagNums;
    }

    public List<String> getShieldSlotMaterialTags() {
        return shieldSlotMaterialTags;
    }

    public void setShieldSlotMaterialTags(List<String> shieldSlotMaterialTags) {
        this.shieldSlotMaterialTags = shieldSlotMaterialTags;
    }

}

