package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.AdvertInSlotsShieldStatusDto;
import cn.com.duiba.tuia.ssp.center.api.params.advertselect.AdvertInSlotsShieldStatusQuery;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.AdvertAndTagSelectedRsp;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.AdvertBaseReq;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.AdvertTagChangeReq;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 提供给广告端的远程服务接口
 *
 * @author hillchen
 * @create 2018/10/18 下午5:06
 */
@AdvancedFeignClient
public interface RemoteAdvertSelectV2Service {
    /**
     * 上报广告行业标签变更
     * @param advertTagChangeReq
     * @return
     */
    boolean reportAdvertTagChange(AdvertTagChangeReq advertTagChangeReq);

    /**
     * 上报广告删除
     * @param advertIds
     * @return
     */
    boolean reportAdvertDelete(List<Long> advertIds);

    /**
     * 上报新增广告
     * @param advertBaseReq
     * @return
     */
    boolean reportNewAdvert(AdvertBaseReq advertBaseReq);

    /**
     * 上报广告素材变更
     * @param advertBaseReq
     * @return
     */
    boolean reportAdvertMaterialChange(AdvertBaseReq advertBaseReq);

    AdvertAndTagSelectedRsp getSlotConfig(Long slotId);

    boolean checkAdvertVisibleByShield(AdvertBaseReq advertBaseReq,Long mediaId);

    boolean checkAdvertVisible(AdvertBaseReq advertBaseReq,Long mediaId);

    List<AdvertInSlotsShieldStatusDto> queryAdvertInSlotsShieldStatus(AdvertInSlotsShieldStatusQuery param);
}