package cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign;


import com.alibaba.fastjson.JSONObject;

/**
 * 〈一句话功能简述〉<br>
 * Description: 上上签请求响应结果对象
 *
 * @author hillchen
 * @create 2019/1/17 13:44
 */
public class BestsignRequestStringResult  {
    /**
     * 异常错误码
     */
    private Integer errno;
    /**
     * 响应结果主体
     */
    private String data;
    /**
     * 请求耗时：毫秒数
     */
    private Long cost;
    /**
     * 异常消息
     */
    private String errmsg;


    public <T> BestsignRequestResult<T> convert(Class<T> dataType){

        T data = null;
        if(getData() != null){
            data = JSONObject.parseObject(getData(),dataType);
        }

        return new BestsignRequestResult(getErrno(),data,getCost(),getErrmsg());
    }

    public Integer getErrno() {
        return errno;
    }

    public void setErrno(Integer errno) {
        this.errno = errno;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Long getCost() {
        return cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public String getErrmsg() {
        return errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }
}