package cn.com.duiba.tuia.ssp.center.api.remote.econtract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.contract.EcontContractBackAddressInfo;
import cn.com.duiba.tuia.ssp.center.api.econtract.dto.contract.EcontContractInfo;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 合同信息远程服务类
 *
 * @author hillchen
 * @create 2019/1/27 17:09
 */
@AdvancedFeignClient
public interface RemoteEcontContractService {
    boolean insert(EcontContractInfo econtContractInfo);

    void insertOldContractInfo(EcontContractInfo econtContractInfo);

    int insertContractStatus(EcontContractInfo econtContractInfo);

    int updateContractStatus(EcontContractInfo econtContractInfo);

    boolean updateStatus(String bestContractId,Integer contractStatus);

    List<EcontContractInfo> findValidEcontContracts(Long mediaId);

    EcontContractInfo findEcontContractByLocal(String localContractId);

    EcontContractInfo findEcontContractByBest(String bestContractId);

    boolean disValidEcontContract(Long mediaId,Integer contractType);

    /**
     * 合同状态
     * @param mediaId
     * @return
     */
    boolean getContractStatus(Long mediaId);

    /**
     * 查询 合同邮寄地址 list
     * @param mediaIds
     * @return
     */
    List<EcontContractInfo> findValidEcontContractList(List<Long> mediaIds);


    /**
     * 查询 合同邮寄地址 设计到兼容问题 老数据
     * @param mediaId
     * @return
     */
    EcontContractBackAddressInfo queryContractBackAddress(Long mediaId);

    /**
     * 查询 合同邮寄地址 单纯找数据
     * @param mediaId
     * @return
     */
    EcontContractBackAddressInfo selectContractBackAddress(Long mediaId);

    /**
     * 保存 合同邮寄地址
     * @param addressInfo
     * @return
     */
    Boolean insertContractBackAddress(EcontContractBackAddressInfo addressInfo);

    /**
     * 更新 合同邮寄地址
     * @param addressInfo
     * @return
     */
    Boolean updateContractBackAddress(EcontContractBackAddressInfo addressInfo);


    /**
     * 删除合同邮寄地址
     * @param mediaId
     * @return
     */
    void deleteContractBackAddress(Long mediaId);


    boolean getContractList(Long mediaId);
}