package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * Function: 活动实体，同步兑吧活动
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public class ActivityDto extends BaseDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 4003070998417689913L;

    /** 活动ID */
    private Long              activityId;

    /** 活动名称 */
    private String            activityName;

    /** 活动类型 */
    private Integer           activityType;

    /** 活动状态 */
    private Integer           activityStatus;

    /** 定向模式： 0仅投放定向列表，1优先投放定向列表 */
    private Integer           directAdvertMode;

    /** 是否定向广告券 */
    private Integer           isDirectAdvert;

    /** 是否定向媒体 */
    private Integer           isDirectMedia;

    /** 活动是否开启 */
    private Integer           isEnable;

    /** 是否已发布活动计划 */
    private Integer           isPublish;

    /** 是否已删除 */
    private Integer           isDelete;

    /** 活动标签 */
    private String            tag;

    /** 活动规格关联关系 */
    private String            activityMsList;

    /** 是否为试投活动 */
    private Integer           isNewAct;

    /** 活动来源 0-兑吧活动 1-推啊活动 2-流量引导页 */
    private Integer           source;

    /** 推广计划名称 */
    private String            planTitle;

    /** 推广计划描述 */
    private String            description;

    /** 活动皮肤类型 */
    private String            subType;

    /** 周期活动表达式 */
    private String            cronExpression;

    /** 周期活动类型 */
    private Integer           cronType;

    /** 是否是海外活动 0正常  1海外*/
    private Integer           overseas;

    /** 活动计划开启时间 */
    private Date enableTime;

    /**
     * source.
     *
     * @return the source
     * @since JDK 1.6
     */
    public Integer getSource() {
        return source;
    }

    /**
     * source.
     *
     * @param source the source to set
     * @since JDK 1.6
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Integer getDelete() {
        return isDelete;
    }

    public void setDelete(Integer delete) {
        isDelete = delete;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getDirectAdvertMode() {
        return directAdvertMode;
    }

    public void setDirectAdvertMode(Integer directAdvertMode) {
        this.directAdvertMode = directAdvertMode;
    }

    public Integer getIsDirectAdvert() {
        return isDirectAdvert;
    }

    public void setIsDirectAdvert(Integer isDirectAdvert) {
        this.isDirectAdvert = isDirectAdvert;
    }

    public Integer getIsDirectMedia() {
        return isDirectMedia;
    }

    public void setIsDirectMedia(Integer isDirectMedia) {
        this.isDirectMedia = isDirectMedia;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getActivityMsList() {
        return activityMsList;
    }

    public void setActivityMsList(String activityMsList) {
        this.activityMsList = activityMsList;
    }

    public Integer getIsNewAct() {
        return isNewAct;
    }

    public void setIsNewAct(Integer isNewAct) {
        this.isNewAct = isNewAct;
    }

    public String getPlanTitle() {
        return planTitle;
    }

    public void setPlanTitle(String planTitle) {
        this.planTitle = planTitle;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Integer getCronType() {
        return cronType;
    }

    public void setCronType(Integer cronType) {
        this.cronType = cronType;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }

    public Date getEnableTime() {
        return enableTime;
    }

    public void setEnableTime(Date enableTime) {
        this.enableTime = enableTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
