package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialToActDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMaterialService {

    DubboResult<Long> insert(MaterialDto record);

    DubboResult<Boolean> update(MaterialDto record);

    DubboResult<Boolean> delete(Long id);

    DubboResult<List<MaterialDto>> listByPage(ReqMaterialDto param);

    DubboResult<List<Long>> listIdByParam(String group, String type);

    DubboResult<Integer> countByParam(ReqMaterialDto param);

    DubboResult<List<MaterialToActDto>> list4Act(Long id, String title, String group, String type, Long msId);

    List<MaterialToActDto> newList4Act(Long id, String title, String group, String type, Long msId,String designer);

    DubboResult<List<MaterialDto>> listByMd5(MaterialDto record);

    DubboResult<MaterialDto> selectById(Long id);

    List<Long> saveBatchMaterial(List<ReqMaterialDto> list);

    boolean submitAudit(Long managerId,Long materialId);

    List<Long> saveBatchMaterialConfig(List<ReqMaterialConfigDto> list);
}
