package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * ClassName:ReqMaterialDto <br/>
 * Function: 素材库查询. <br/>
 * Date:     2017年7月12日 下午3:51:36 <br/>
 * @author   guyan
 * @version
 * @since    JDK 1.6
 * @see
 */
public class ReqMaterialDto extends BaseQueryDto {

    private static final long serialVersionUID = -6871234214516166275L;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    private Long id;

    private String title;

    private Long msId;

    private String pictureGroup;

    private String pictureType;

    private String designer;

    private List<ReqMsChildDto> content;

    private String md5;

    private String msContent;

    private Long tagId;

    /** 搜索限制条件：素材id列表 */
    private List<Long> idList;

    /** 素材开启状态，0：关闭，1：开启，不传：全部 */
    private Integer enableStatus;

    public List<ReqMsChildDto> getContent() {
        return content;
    }

    public void setContent(List<ReqMsChildDto> content) {
        this.content = content;
    }

    public String getMsContent() {
        return msContent;
    }

    public void setMsContent(String msContent) {
        this.msContent = msContent;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public String getPictureGroup() {
        return pictureGroup;
    }

    public void setPictureGroup(String pictureGroup) {
        this.pictureGroup = pictureGroup;
    }

    public String getPictureType() {
        return pictureType;
    }

    public void setPictureType(String pictureType) {
        this.pictureType = pictureType;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
}
