package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
@AdvancedFeignClient
public interface RemoteActivityBackendService {

    /**
     * getByActivityIds:(查询活动接口). <br/>
     *
     * @author ZFZ
     * @param activityIds 查询条件
     * @param actSource 活动来源
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds, int actSource, Map<Integer, String> actTypeMap);

    /**
     * 查询没有删除的推广计划活动
     * @param activityIds
     * @param actSource
     * @return
     */
    List<ActivityDto> getByActivityIdsAndSource(List<Long> activityIds, int actSource);

    /**
     * 发布活动计划
     *
     * @param activities 活动：id+type
     * @param actSource 活动来源 0-兑吧 1-推啊
     * @return Boolean
     */
    DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities, Integer actSource);
    
    /**
     * 查询所有关联该活动的广告位id
     * @param activitiyId
     * @param actSource
     * @return
     */
    DubboResult<Set<Long>> getInfo4CloseAct(Long activitiyId, Integer actSource);

    
    //删除活动计划新接口，活动下广告位排序遍历
    DubboResult<Boolean> deleteActivityPlanBySourceNew(Long activityId, Integer source);

    /**
     * 编辑活动计划
     *
     * @param reqActivityDto
     * @return Boolean
     */
    DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto);

    /**
     * 获取活动定向的媒体
     * 
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaAppBySource(Long activityId, Integer source);

    /**
     * 活动媒体定向
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param source 活动来源
     * @param directStatus 是否开启定向
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    @RequestMapping("/activityDirectToMediaApp2")
    DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType,Integer source, Integer directStatus, List<Long> appIds);
    
    /**
     * 活动媒体定向
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 是否开启定向
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    @RequestMapping("/activityDirectToMediaApp1")
    DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds);

    /**
     * 活动定制广告
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @param directStatus 是否开启定制
     * @param directMode 定向模式
     * @param advertIds 广告ID列表
     * @return Boolean
     */
    DubboResult<Boolean> activityDirectToAdvertBySource(Long activityId, Integer source, Integer directStatus, Integer directMode, List<Long> advertIds,Integer activityType);

    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType);

    /**
     * 查询某个活动在某个广告位下的SPM值
     * 
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 活动SPM
     */
    DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType);

    /**
     * 将活动从试投列表中移除
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActList(Long activityId, Integer activityType);
    
    /**
     * 
     * getCacheActivityName:(查询活动名称). <br/>
     *
     * @param activities 活动ID+活动类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long,String>> getCacheActivityNameBySource(List<ReqIdAndType> activities);

    /**
     * 
     * getActivityIdsByName:(通过活动名称查询活动IDS). <br/>
     *
     * @param activityName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getActivityIdsByName(String activityName);

    /**
     * 开启/关闭活动计划
     *
     * @param activityId
     * @param source
     * @param enableStatus
     * @return Boolean
     */
    DubboResult<Boolean> changeActivityPlanEnableBySource(Long activityId, Integer source, Integer enableStatus,Map<Integer,String> actTypeMap);


    /**
     * 编辑活动计划时查询所有规格列表
     *
     * @return 规格列表
     */
    DubboResult<List<RspMaterialSpecificationDto>> getMsItemList();

    DubboResult<PageResultDto<RspActivityDto>> getPopularizePlanList(ReqActivityDto req,Map<Integer, String> actTypeMap);

    DubboResult<Integer> updateCron(ActivityDto activityDto);

    ActvityAdevertInfoDto queryActivityAdvertInfo(Long activityId, Integer source);

    ActivityDto getDetailBySource(Long activityId,Integer source);


    List<Long> getDirectActs(Integer isDirected);

    List<RspActivityDto> getPublicListByActivityIds(List<Long> activityIds);

    /**
     * 批量开启/关闭活动计划
     * @param activityDtoList
     * @param enableStatus
     * @return Boolean
     */
    Boolean batchChangeActivityPlanEnableBySource(List<ActivityDto> activityDtoList, Integer enableStatus);

    /**
     * 可用标签搜索活动推广计划列表
     * @param req
     * @param actTypeMap
     * @param tagId
     * @return
     */
    PageResultDto<RspActivityDto> getPopularizePlanListWithTag(ReqActivityDto req, Map<Integer, String> actTypeMap, Long tagId);

    /**
     * 获取勾选要关闭活动推广计划中不包含媒体定向的、广告定制的、仅投以及定时投放、周期性投放、原生的活动的数量与集合
     * @param activityDtoList
     * @param enableStatus
     * @return
     */
    ActivityPlanDataRsp getChangeActivityPlanData(List<ActivityDto> activityDtoList, Integer enableStatus);
}
