package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordReq;
import cn.com.duiba.wolf.utils.BeanUtils;

import java.util.List;

/**
 * 预付款发票纪录
 */
@AdvancedFeignClient
public interface RemotePrePayInvoiceRecordService {
    /**
     * 预付款发票纪录
     *
     * @param param
     * @return
     */
    PageResultDto<PrePayInvoiceRecordDto> pagePrePayInvoiceRecord(PrePayInvoiceRecordReq param);

    /**
     * 保存
     *
     * @param param
     */
    Boolean savePrePayInvoiceRecord(PrePayInvoiceRecordDto param);

    /**
     * 修改
     *
     * @param param
     */
    Boolean updatePrePayInvoiceRecord(PrePayInvoiceRecordDto param);

    /**
     * 删除预付款发票
     * id:发票ID
     */
    Boolean deletePrePayInvoiceRecordById(Long id);

    /**
     * 查询预付款发票
     */
    List<PrePayInvoiceRecordDto> listPrePayInvoiceRecord(PrePayInvoiceRecordReq param);

    /**
     * 通过媒体用户IDS
     *
     * @return
     */
    List<PrePayInvoiceRecordDto> listPrePayInvoiceRecordByParam(PrePayInvoiceRecordReq param);


    List<PrePayInvoiceRecordDto> listAndGroupByMediaIds(List<Long> mediaIds);

}
