package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.constant.NewMediaTestEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.NewMediaTestDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMarkAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPageQuery;

import java.util.List;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/8 11:24
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteNewMediaTestService {

    /**
     * 分页查询新媒体列表
     * @param req
     * @return
     */
    PageResultDto<NewMediaTestDto> pageList(ReqPageQuery req);

    /**
     * 参加或不参加测试
     * @param id
     * @param appMark
     * @return
     */
    int markApp(Long id, ReqMarkAppDto appMark);

    /**
     * 修改测试状态
     * @param appIds
     * @param statusEnum
     * @return
     */
    int modifyStatus(List<Long> appIds, NewMediaTestEnum.StatusEnum statusEnum);


    /**
     * 查询所有的在测试中的媒体
     * @return
     */
    List<NewMediaTestDto> getAllTestingMedia();


    int insert(List<Long> appIds);
}
