package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialForSlot;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialToActDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMaterialService {

    DubboResult<Long> insert(MaterialDto record);

    DubboResult<Boolean> update(MaterialDto record);

    DubboResult<Boolean> delete(Long id);

    DubboResult<List<MaterialDto>> listByPage(ReqMaterialDto param);

    DubboResult<List<Long>> listIdByParam(String group, String type);

    DubboResult<Integer> countByParam(ReqMaterialDto param);

    DubboResult<List<MaterialToActDto>> list4Act(Long id, String title, String group, String type, Long msId);

    List<MaterialToActDto> newList4Act(Long id, String title, String group, String type, Long msId,String designer);

    DubboResult<List<MaterialDto>> listByMd5(MaterialDto record);

    DubboResult<MaterialDto> selectById(Long id);

    List<Long> saveBatchMaterial(List<ReqMaterialDto> list);

    boolean submitAudit(Long managerId,Long materialId);

    List<MaterialForSlot> getListForSlot(Long slotId);

    boolean materialChange();

    List<Long> saveBatchMaterialConfig(List<ReqMaterialConfigDto> list);

    boolean transferMaterialGroupToTag();

    boolean updateMaterialTag(List<String> tagIdStringList, Long materialId);

    List<MaterialToActDto> newList4ActByReqMaterialDto(ReqMaterialDto reqMaterialDto);

    /**
     * 更新素材库（只更新素材库这一张表，即tb_material，慎用）
     *
     * @param id
     * @param pictureSize
     * @return
     */
    Boolean initPictureSize(Long id, Long pictureSize);

    /**
     * 查询出所有没有大小的素材（初始化素材大小时使用）
     *
     * @return
     */
    List<MaterialDto> queryMaterialNoSize();

    boolean updateMaterialTitleAndDesc(List<MaterialDto> materialDtos);
}
